% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparkwarc.R
\name{spark_read_warc}
\alias{spark_read_warc}
\title{Reads a WARC File into Apache Spark}
\usage{
spark_read_warc(
  sc,
  name,
  path,
  repartition = 0L,
  memory = TRUE,
  overwrite = TRUE,
  match_warc = "",
  match_line = "",
  parser = c("r", "scala"),
  ...
)
}
\arguments{
\item{sc}{An active \code{spark_connection}.}

\item{name}{The name to assign to the newly generated table.}

\item{path}{The path to the file. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3n://"} and \samp{"file://"} protocols.}

\item{repartition}{The number of partitions used to distribute the
generated table. Use 0 (the default) to avoid partitioning.}

\item{memory}{Boolean; should the data be loaded eagerly into memory? (That
is, should the table be cached?)}

\item{overwrite}{Boolean; overwrite the table with the given name if it
already exists?}

\item{match_warc}{include only warc files mathcing this character string.}

\item{match_line}{include only lines mathcing this character string.}

\item{parser}{which parser implementation to use? Options are "scala"
or "r" (default).}

\item{...}{Additional arguments reserved for future use.}
}
\description{
Reads a WARC (Web ARChive) file into Apache Spark using sparklyr.
}
\examples{

\dontrun{
library(sparklyr)
sc <- spark_connect(master = "spark://HOST:PORT")
df <- spark_read_warc(
  sc,
  system.file("samples/sample.warc", package = "sparkwarc"),
  repartition = FALSE,
  memory = FALSE,
  overwrite = FALSE
)

spark_disconnect(sc)
}

}
