% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_evaluate.R, R/ml_evaluator.R
\name{ml_evaluate}
\alias{ml_evaluate}
\alias{ml_evaluate.ml_model_logistic_regression}
\alias{ml_evaluate.ml_logistic_regression_model}
\alias{ml_evaluate.ml_model_linear_regression}
\alias{ml_evaluate.ml_linear_regression_model}
\alias{ml_evaluate.ml_model_generalized_linear_regression}
\alias{ml_evaluate.ml_generalized_linear_regression_model}
\alias{ml_evaluate.ml_model_clustering}
\alias{ml_evaluate.ml_model_classification}
\alias{ml_evaluate.ml_evaluator}
\title{Evaluate the Model on a Validation Set}
\usage{
ml_evaluate(x, dataset)

\method{ml_evaluate}{ml_model_logistic_regression}(x, dataset)

\method{ml_evaluate}{ml_logistic_regression_model}(x, dataset)

\method{ml_evaluate}{ml_model_linear_regression}(x, dataset)

\method{ml_evaluate}{ml_linear_regression_model}(x, dataset)

\method{ml_evaluate}{ml_model_generalized_linear_regression}(x, dataset)

\method{ml_evaluate}{ml_generalized_linear_regression_model}(x, dataset)

\method{ml_evaluate}{ml_model_clustering}(x, dataset)

\method{ml_evaluate}{ml_model_classification}(x, dataset)

\method{ml_evaluate}{ml_evaluator}(x, dataset)
}
\arguments{
\item{x}{An ML model object or an evaluator object.}

\item{dataset}{The dataset to be validate the model on.}
}
\description{
Compute performance metrics.
}
\examples{
\dontrun{
sc <- spark_connect(master = "local")
iris_tbl <- sdf_copy_to(sc, iris, name = "iris_tbl", overwrite = TRUE)

ml_gaussian_mixture(iris_tbl, Species ~ .) \%>\%
  ml_evaluate(iris_tbl)

ml_kmeans(iris_tbl, Species ~ .) \%>\%
  ml_evaluate(iris_tbl)

ml_bisecting_kmeans(iris_tbl, Species ~ .) \%>\%
  ml_evaluate(iris_tbl)
}

}
