% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_feature_sql_transformer.R,
%   R/ml_feature_dplyr_transformer.R
\name{ft_sql_transformer}
\alias{ft_sql_transformer}
\alias{ft_dplyr_transformer}
\title{Feature Transformation -- SQLTransformer}
\usage{
ft_sql_transformer(
  x,
  statement = NULL,
  uid = random_string("sql_transformer_"),
  ...
)

ft_dplyr_transformer(x, tbl, uid = random_string("dplyr_transformer_"), ...)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{statement}{A SQL statement.}

\item{uid}{A character string used to uniquely identify the feature transformer.}

\item{...}{Optional arguments; currently unused.}

\item{tbl}{A \code{tbl_spark} generated using \code{dplyr} transformations.}
}
\value{
The object returned depends on the class of \code{x}. If it is a
\code{spark_connection}, the function returns a \code{ml_estimator} or a
\code{ml_estimator} object. If it is a \code{ml_pipeline}, it will return
a pipeline with the transformer or estimator appended to it. If a
\code{tbl_spark}, it will return a \code{tbl_spark} with the transformation
 applied to it.
}
\description{
Implements the transformations which are defined by SQL statement. Currently we
  only support SQL syntax like 'SELECT ... FROM __THIS__ ...' where '__THIS__' represents
  the underlying table of the input dataset. The select clause specifies the
  fields, constants, and expressions to display in the output, it can be any
  select clause that Spark SQL supports. Users can also use Spark SQL built-in
  function and UDFs to operate on these selected columns.
}
\details{
\code{ft_dplyr_transformer()} is mostly a wrapper around \code{ft_sql_transformer()} that
  takes a \code{tbl_spark} instead of a SQL statement. Internally, the \code{ft_dplyr_transformer()}
  extracts the \code{dplyr} transformations used to generate \code{tbl} as a SQL statement or a
  sampling operation. Note that only single-table \code{dplyr} verbs are supported and that the
  \code{sdf_} family of functions are not.
}
\seealso{
Other feature transformers: 
\code{\link{ft_binarizer}()},
\code{\link{ft_bucketizer}()},
\code{\link{ft_chisq_selector}()},
\code{\link{ft_count_vectorizer}()},
\code{\link{ft_dct}()},
\code{\link{ft_elementwise_product}()},
\code{\link{ft_feature_hasher}()},
\code{\link{ft_hashing_tf}()},
\code{\link{ft_idf}()},
\code{\link{ft_imputer}()},
\code{\link{ft_index_to_string}()},
\code{\link{ft_interaction}()},
\code{\link{ft_lsh}},
\code{\link{ft_max_abs_scaler}()},
\code{\link{ft_min_max_scaler}()},
\code{\link{ft_ngram}()},
\code{\link{ft_normalizer}()},
\code{\link{ft_one_hot_encoder_estimator}()},
\code{\link{ft_one_hot_encoder}()},
\code{\link{ft_pca}()},
\code{\link{ft_polynomial_expansion}()},
\code{\link{ft_quantile_discretizer}()},
\code{\link{ft_r_formula}()},
\code{\link{ft_regex_tokenizer}()},
\code{\link{ft_robust_scaler}()},
\code{\link{ft_standard_scaler}()},
\code{\link{ft_stop_words_remover}()},
\code{\link{ft_string_indexer}()},
\code{\link{ft_tokenizer}()},
\code{\link{ft_vector_assembler}()},
\code{\link{ft_vector_indexer}()},
\code{\link{ft_vector_slicer}()},
\code{\link{ft_word2vec}()}
}
\concept{feature transformers}
