% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{spark_read_binary}
\alias{spark_read_binary}
\title{Read binary data into a Spark DataFrame.}
\usage{
spark_read_binary(
  sc,
  name = NULL,
  dir = name,
  path_glob_filter = "*",
  recursive_file_lookup = FALSE,
  repartition = 0,
  memory = TRUE,
  overwrite = TRUE
)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{name}{The name to assign to the newly generated table.}

\item{dir}{Directory to read binary files from.}

\item{path_glob_filter}{Glob pattern of binary files to be loaded
(e.g., "*.jpg").}

\item{recursive_file_lookup}{If FALSE (default), then partition discovery
will be enabled (i.e., if a partition naming scheme is present, then
partitions specified by subdirectory names such as "date=2019-07-01" will
be created and files outside subdirectories following a partition naming
scheme will be ignored). If TRUE, then all nested directories will be
searched even if their names do not follow a partition naming scheme.}

\item{repartition}{The number of partitions used to distribute the
generated table. Use 0 (the default) to avoid partitioning.}

\item{memory}{Boolean; should the data be loaded eagerly into memory? (That
is, should the table be cached?)}

\item{overwrite}{Boolean; overwrite the table with the given name if it
already exists?}
}
\description{
Read binary files within a directory and convert each file into a record
within the resulting Spark dataframe. The output will be a Spark dataframe
with the following columns and possibly partition columns:
  \itemize{
    \item path: StringType
    \item modificationTime: TimestampType
    \item length: LongType
    \item content: BinaryType
 }
}
\seealso{
Other Spark serialization routines: 
\code{\link{collect_from_rds}()},
\code{\link{spark_insert_table}()},
\code{\link{spark_load_table}()},
\code{\link{spark_read_avro}()},
\code{\link{spark_read_csv}()},
\code{\link{spark_read_delta}()},
\code{\link{spark_read_image}()},
\code{\link{spark_read_jdbc}()},
\code{\link{spark_read_json}()},
\code{\link{spark_read_libsvm}()},
\code{\link{spark_read_orc}()},
\code{\link{spark_read_parquet}()},
\code{\link{spark_read_source}()},
\code{\link{spark_read_table}()},
\code{\link{spark_read_text}()},
\code{\link{spark_read}()},
\code{\link{spark_save_table}()},
\code{\link{spark_write_avro}()},
\code{\link{spark_write_csv}()},
\code{\link{spark_write_delta}()},
\code{\link{spark_write_jdbc}()},
\code{\link{spark_write_json}()},
\code{\link{spark_write_orc}()},
\code{\link{spark_write_parquet}()},
\code{\link{spark_write_source}()},
\code{\link{spark_write_table}()},
\code{\link{spark_write_text}()}
}
\concept{Spark serialization routines}
