/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.Serialization$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import sparklyr.SchemaUtils;

public final class SchemaUtils$ {
    public static SchemaUtils$ MODULE$;

    static {
        new SchemaUtils$();
    }

    public String sdfSchema(Dataset<Row> sdf, boolean expandNestedCols, boolean expandStructCols) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        SchemaUtils.DType schema = this.structTypeToSchema(sdf.schema(), expandNestedCols, expandStructCols);
        return Serialization$.MODULE$.write((Object)schema, (Formats)formats);
    }

    private SchemaUtils.DType structTypeToSchema(StructType structType, boolean expandNestedCols, boolean expandStructCols) {
        SchemaUtils.Field[] fields = (SchemaUtils.Field[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)x -> {
            SchemaUtils.DType dType;
            String string = x.name();
            DataType dtype = x.dataType();
            if (expandStructCols && dtype instanceof StructType) {
                dType = MODULE$.structTypeToSchema((StructType)dtype, expandNestedCols, expandStructCols);
            } else if (expandNestedCols && MODULE$.isStructArr(dtype)) {
                DataType elementType = ((ArrayType)dtype).elementType();
                dType = new SchemaUtils.NestedColsDType(MODULE$.structTypeToSchema((StructType)elementType, expandNestedCols, expandStructCols));
            } else {
                dType = new SchemaUtils.GenericDType(dtype.toString());
            }
            return new SchemaUtils.Field(string, dType);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SchemaUtils.Field.class)));
        return new SchemaUtils.StructDType(fields);
    }

    private boolean isStructArr(DataType dtype) {
        boolean bl;
        if (dtype instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dtype;
            bl = arrayType.elementType() instanceof StructType;
        } else {
            bl = false;
        }
        return bl;
    }

    public Dataset<Row> castColumns(Dataset<Row> sdf, StructType desiredSchema) {
        Map<String, DataType> desiredColumnTypes = this.extractColumnTypes(desiredSchema);
        Map<String, DataType> inputColumnTypes = this.extractColumnTypes(sdf.schema());
        Column[] outputColumns = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sdf.schema().fieldNames())).map((Function1 & Serializable & scala.Serializable)column -> {
            DataType columnType = (DataType)desiredColumnTypes.getOrElse(column, (Function0 & Serializable & scala.Serializable)() -> (DataType)inputColumnTypes.get(column).get());
            return new Column(column).cast(columnType);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return sdf.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])outputColumns));
    }

    private Map<String, DataType> extractColumnTypes(StructType schema) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x.name()), (Object)x.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    private SchemaUtils$() {
        MODULE$ = this;
    }
}

