% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_interface.R
\name{[.tbl_spark}
\alias{[.tbl_spark}
\title{Subsetting operator for Spark dataframe}
\usage{
\method{[}{tbl_spark}(x, i)
}
\arguments{
\item{x}{The Spark dataframe}

\item{i}{Expression specifying subset of column(s) to include or exclude
from the result (e.g., `["col1"]`, `[c("col1", "col2")]`, `[1:10]`, `[-1]`,
`[NULL]`, or `[]`)}
}
\description{
Susetting operator for Spark dataframe allowing a subset of column(s) to be
selected using syntaxes similar to those supported by R dataframes
}
\examples{

\dontrun{
library(sparklyr)
sc <- spark_connect(master = "spark://HOST:PORT")
example_sdf <- copy_to(sc, tibble::tibble(a = 1, b = 2))
example_sdf["a"] \%>\% print()
}

}
