% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_hof.R
\name{hof_transform_keys}
\alias{hof_transform_keys}
\title{Transforms keys of a map}
\usage{
hof_transform_keys(x, func, expr = NULL, dest_col = NULL, ...)
}
\arguments{
\item{x}{The Spark data frame to be processed}

\item{func}{The transformation function to apply (it should take (key, value) as
arguments and return a transformed key)}

\item{expr}{The map being transformed, could be any SQL expression evaluating to a map
(default: the last column of the Spark data frame)}

\item{dest_col}{Column to store the transformed result (default: expr)}

\item{...}{Additional params to dplyr::mutate}
}
\description{
Applies the transformation function specified to all keys of a map
(this is essentially a dplyr wrapper to the `transform_keys(expr, func)` higher-
order function, which is supported since Spark 3.0)
}
\examples{
\dontrun{

library(sparklyr)
sc <- spark_connect(master = "local", version = "3.0.0")
sdf <- sdf_len(sc, 1) \%>\% dplyr::mutate(m = map("a", 0L, "b", 2L, "c", -1L))
transformed_sdf <- sdf \%>\% hof_transform_keys(~ CONCAT(.x, " == ", .y))
}

}
