/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.DataInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import sparklyr.Logger;
import sparklyr.Serializer$;

public final class RUtils$ {
    public static RUtils$ MODULE$;
    private final char XDR_FORMAT;
    private final int CHARSXP;
    private final int LGLSXP;
    private final int INTSXP;
    private final int REALSXP;
    private final int STRSXP;
    private final int VECSXP;
    private final int RAWSXP;
    private final int NILVALUE_SXP;
    private final int NA_INTEGER;

    static {
        new RUtils$();
    }

    public void validateSerializationFormat(DataInputStream dis, boolean verbose) {
        block2: {
            char format = Serializer$.MODULE$.readObjectType(dis);
            dis.readByte();
            if (this.XDR_FORMAT != format) {
                throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported R serialization format '").append(format).append("'").toString());
            }
            int version = Serializer$.MODULE$.readInt(dis);
            int writerVersion = Serializer$.MODULE$.readInt(dis);
            int minReaderVersion = Serializer$.MODULE$.readInt(dis);
            if (version != 2) {
                throw new IllegalArgumentException(new StringBuilder(38).append("Unsupported R serialization version '").append(version).append("'").toString());
            }
            if (!verbose) break block2;
            Logger logger = new Logger("Utils", 0);
            logger.log(new StringBuilder(25).append("R serialization version: ").append(version).toString());
            logger.log(new StringBuilder(32).append("R serialization writer version: ").append(writerVersion).toString());
            logger.log(new StringBuilder(36).append("R serialization min reader version: ").append(minReaderVersion).toString());
        }
    }

    public boolean validateSerializationFormat$default$2() {
        return false;
    }

    public Object[] unserializeColumn(DataInputStream dis) {
        Logger logger = new Logger("RUtils", 0);
        int dtype = this.readDataType(dis);
        if (this.VECSXP != dtype) {
            logger.logWarning(new StringBuilder(28).append("Unexpected column data type ").append(dtype).toString());
        }
        long num_rows = this.readLength(dis);
        return (Object[])((TraversableOnce)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)num_rows)).map((Function1 & Serializable & scala.Serializable)r -> RUtils$.$anonfun$unserializeColumn$1(dis, logger, BoxesRunTime.unboxToLong((Object)r)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
    }

    private int[] unserializeIntColumn(DataInputStream dis) {
        return (int[])Array$.MODULE$.fill(5, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int());
    }

    private String[] unserializeStringColumn(DataInputStream dis) {
        return (String[])Array$.MODULE$.fill(5, (Function0 & Serializable & scala.Serializable)() -> "", ClassTag$.MODULE$.apply(String.class));
    }

    private int readDataType(DataInputStream dis) {
        return Serializer$.MODULE$.readInt(dis) & 0xFF;
    }

    private long readLength(DataInputStream dis) {
        int x = Serializer$.MODULE$.readInt(dis);
        if (-1 == x) {
            throw new IllegalArgumentException("Vector with length greater than INT_MAX (i.e., 'LONG_VECTOR') is not supported yet");
        }
        int len = x;
        if (len < 0) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Negative serialized vector length: ").append(len).toString());
        }
        return len;
    }

    private int extractInt(byte[] bytes, int offset) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> (Predef$.MODULE$.byte2Byte(bytes[offset + i]).intValue() & 0xFF) << 24 - i * 8, IndexedSeq$.MODULE$.canBuildFrom())).reduce((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(p, q) -> p | q));
    }

    public static final /* synthetic */ Object $anonfun$unserializeColumn$1(DataInputStream dis$1, Logger logger$1, long r) {
        byte[] byArray;
        int elem_dtype = MODULE$.readDataType(dis$1);
        if (RUtils$.MODULE$.NILVALUE_SXP == elem_dtype) {
            byArray = null;
        } else {
            long num_elems = MODULE$.readLength(dis$1);
            if (RUtils$.MODULE$.RAWSXP == elem_dtype) {
                byte[] bytes = new byte[Predef$.MODULE$.long2Long(num_elems).intValue()];
                dis$1.readFully(bytes);
                byArray = bytes;
            } else {
                Comparable<Boolean> comparable;
                if (1L != num_elems) {
                    throw new IllegalArgumentException(new StringBuilder(31).append("Unexpected number of elements: ").append(num_elems).toString());
                }
                int n = elem_dtype;
                if (RUtils$.MODULE$.LGLSXP == n) {
                    int v = Serializer$.MODULE$.readInt(dis$1);
                    comparable = RUtils$.MODULE$.NA_INTEGER == v ? null : BoxesRunTime.boxToBoolean((v != 0 ? 1 : 0) != 0);
                } else if (RUtils$.MODULE$.INTSXP == n) {
                    int v = Serializer$.MODULE$.readInt(dis$1);
                    comparable = RUtils$.MODULE$.NA_INTEGER == v ? null : BoxesRunTime.boxToInteger((int)v);
                } else if (RUtils$.MODULE$.REALSXP == n) {
                    byte[] bytes = new byte[8];
                    dis$1.readFully(bytes);
                    long hw = (long)MODULE$.extractInt(bytes, 0) & 0xFFFFFFFFL;
                    long lw = (long)MODULE$.extractInt(bytes, 4) & 0xFFFFFFFFL;
                    comparable = hw == 0x7FF00000L && lw == 1954L ? null : BoxesRunTime.boxToDouble((double)Double.longBitsToDouble(hw << 32 | lw));
                } else if (RUtils$.MODULE$.STRSXP == n) {
                    String string;
                    int strlen;
                    int ctype = MODULE$.readDataType(dis$1);
                    if (RUtils$.MODULE$.CHARSXP != ctype) {
                        logger$1.logWarning(new StringBuilder(53).append("Unexpected character type ").append(ctype).append(" found in string expression").toString());
                    }
                    if (-1L == (long)(strlen = Serializer$.MODULE$.readInt(dis$1))) {
                        string = null;
                    } else {
                        byte[] bytes = new byte[Predef$.MODULE$.int2Integer(strlen).intValue()];
                        dis$1.readFully(bytes);
                        string = new String(bytes, StandardCharsets.UTF_8);
                    }
                    comparable = string;
                } else {
                    throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(elem_dtype).toString());
                }
                byArray = comparable;
            }
        }
        return byArray;
    }

    private RUtils$() {
        MODULE$ = this;
        this.XDR_FORMAT = (char)88;
        this.CHARSXP = 9;
        this.LGLSXP = 10;
        this.INTSXP = 13;
        this.REALSXP = 14;
        this.STRSXP = 16;
        this.VECSXP = 19;
        this.RAWSXP = 24;
        this.NILVALUE_SXP = 254;
        this.NA_INTEGER = Integer.MIN_VALUE;
    }
}

