/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.Serializable;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.util.matching.Regex;

public final class SQLUtils$ {
    public static SQLUtils$ MODULE$;

    static {
        new SQLUtils$();
    }

    public StructType createStructType(Seq<StructField> fields) {
        return StructType$.MODULE$.apply(fields);
    }

    public DataType getSQLDataType(String dataType) {
        BooleanType$ booleanType$;
        Regex RegexArray = new StringOps(Predef$.MODULE$.augmentString("\\Aarray<(.+)>\\Z")).r((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"elemType"}));
        Regex RegexMap = new StringOps(Predef$.MODULE$.augmentString("\\Amap<(.+),(.+)>\\Z")).r((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyType", "valueType"}));
        Regex RegexStruct = new StringOps(Predef$.MODULE$.augmentString("\\Astruct<(.+)>\\Z")).r((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fieldsStr"}));
        Regex RegexStructField = new StringOps(Predef$.MODULE$.augmentString("\\A(.+):(.+)\\Z")).r((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fieldName", "fieldType"}));
        String string = dataType;
        if ("BooleanType".equals(string)) {
            booleanType$ = BooleanType$.MODULE$;
        } else if ("ByteType".equals(string)) {
            booleanType$ = ByteType$.MODULE$;
        } else if ("IntegerType".equals(string)) {
            booleanType$ = IntegerType$.MODULE$;
        } else if ("LongType".equals(string)) {
            booleanType$ = LongType$.MODULE$;
        } else if ("FloatType".equals(string)) {
            booleanType$ = FloatType$.MODULE$;
        } else if ("DoubleType".equals(string)) {
            booleanType$ = DoubleType$.MODULE$;
        } else if ("StringType".equals(string)) {
            booleanType$ = StringType$.MODULE$;
        } else if ("TimestampType".equals(string)) {
            booleanType$ = TimestampType$.MODULE$;
        } else if ("DateType".equals(string)) {
            booleanType$ = DateType$.MODULE$;
        } else if ("BinaryType".equals(string)) {
            booleanType$ = BinaryType$.MODULE$;
        } else if ("byte".equals(string)) {
            booleanType$ = ByteType$.MODULE$;
        } else if ("integer".equals(string)) {
            booleanType$ = IntegerType$.MODULE$;
        } else if ("integer64".equals(string)) {
            booleanType$ = LongType$.MODULE$;
        } else if ("float".equals(string)) {
            booleanType$ = FloatType$.MODULE$;
        } else if ("double".equals(string)) {
            booleanType$ = DoubleType$.MODULE$;
        } else if ("numeric".equals(string)) {
            booleanType$ = DoubleType$.MODULE$;
        } else if ("long".equals(string)) {
            booleanType$ = LongType$.MODULE$;
        } else if ("character".equals(string)) {
            booleanType$ = StringType$.MODULE$;
        } else if ("factor".equals(string)) {
            booleanType$ = StringType$.MODULE$;
        } else if ("string".equals(string)) {
            booleanType$ = StringType$.MODULE$;
        } else if ("binary".equals(string)) {
            booleanType$ = BinaryType$.MODULE$;
        } else if ("raw".equals(string)) {
            booleanType$ = BinaryType$.MODULE$;
        } else if ("logical".equals(string)) {
            booleanType$ = BooleanType$.MODULE$;
        } else if ("boolean".equals(string)) {
            booleanType$ = BooleanType$.MODULE$;
        } else if ("POSIXct".equals(string)) {
            booleanType$ = TimestampType$.MODULE$;
        } else if ("POSIXlt".equals(string)) {
            booleanType$ = TimestampType$.MODULE$;
        } else if ("timestamp".equals(string)) {
            booleanType$ = TimestampType$.MODULE$;
        } else if ("Date".equals(string)) {
            booleanType$ = DateType$.MODULE$;
        } else if ("date".equals(string)) {
            booleanType$ = DateType$.MODULE$;
        } else {
            Option option = RegexArray.unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String elemType = (String)((LinearSeqOptimized)option.get()).apply(0);
                booleanType$ = ArrayType$.MODULE$.apply(this.getSQLDataType(elemType));
            } else {
                Option option2 = RegexMap.unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String keyType = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    String valueType = (String)((LinearSeqOptimized)option2.get()).apply(1);
                    String string2 = keyType;
                    String string3 = "string";
                    if (string2 == null ? string3 != null : !string2.equals(string3)) {
                        String string4 = keyType;
                        String string5 = "character";
                        if (string4 == null ? string5 != null : !string4.equals(string5)) {
                            throw new IllegalArgumentException("Key type of a map must be string or character");
                        }
                    }
                    booleanType$ = MapType$.MODULE$.apply(this.getSQLDataType(keyType), this.getSQLDataType(valueType));
                } else {
                    Option option3 = RegexStruct.unapplySeq((CharSequence)string);
                    if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0) {
                        String fieldsStr = (String)((LinearSeqOptimized)option3.get()).apply(0);
                        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(fieldsStr), fieldsStr.length() - 1) == ',') {
                            throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(dataType).toString());
                        }
                        String[] fields = fieldsStr.split(",");
                        StructField[] structFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)field -> {
                            String string = field;
                            Option option = RegexStructField.unapplySeq((CharSequence)string);
                            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) {
                                throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(dataType).toString());
                            }
                            String fieldName = (String)((LinearSeqOptimized)option.get()).apply(0);
                            String fieldType = (String)((LinearSeqOptimized)option.get()).apply(1);
                            StructField structField = MODULE$.createStructField(fieldName, fieldType, true);
                            return structField;
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
                        booleanType$ = this.createStructType((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])structFields));
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(dataType).toString());
                    }
                }
            }
        }
        return booleanType$;
    }

    public StructField createStructField(String name, String dataType, boolean nullable) {
        DataType dtObj = this.getSQLDataType(dataType);
        return new StructField(name, dtObj, nullable, StructField$.MODULE$.apply$default$4());
    }

    private SQLUtils$() {
        MODULE$ = this;
    }
}

