% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{spark_write_source}
\alias{spark_write_source}
\title{Writes a Spark DataFrame into a generic source}
\usage{
spark_write_source(x, name, source, mode = NULL, options = list(),
  partition_by = NULL, ...)
}
\arguments{
\item{x}{A Spark DataFrame or dplyr operation}

\item{name}{The name to assign to the newly generated table.}

\item{source}{A data source capable of reading data.}

\item{mode}{Specifies the behavior when data or table already exists.}

\item{options}{A list of strings with additional options.}

\item{partition_by}{Partitions the output by the given columns on the file system.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Writes a Spark DataFrame into a generic source.
}
\seealso{
Other Spark serialization routines: \code{\link{spark_load_table}},
  \code{\link{spark_read_csv}},
  \code{\link{spark_read_jdbc}},
  \code{\link{spark_read_json}},
  \code{\link{spark_read_parquet}},
  \code{\link{spark_read_source}},
  \code{\link{spark_read_table}},
  \code{\link{spark_read_text}},
  \code{\link{spark_save_table}},
  \code{\link{spark_write_csv}},
  \code{\link{spark_write_jdbc}},
  \code{\link{spark_write_json}},
  \code{\link{spark_write_parquet}},
  \code{\link{spark_write_table}},
  \code{\link{spark_write_text}}
}
\concept{Spark serialization routines}
