% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{spec_decomp}
\alias{spec_decomp}
\title{Decompose an mrs_data object into white and gray matter spectra.}
\usage{
spec_decomp(mrs_data, wm, gm, norm_fractions = TRUE)
}
\arguments{
\item{mrs_data}{data to be decomposed into white and gray matter spectra.}

\item{wm}{vector of white matter contributions to each voxel.}

\item{gm}{vector of gray matter contributions to each voxel.}

\item{norm_fractions}{option to normalise the wm, gm vectors for each voxel.}
}
\value{
a list of two mrs_data objects corresponding to the two tissue types.
}
\description{
An implementation of the method published by Goryawala et al MRM 79(6)
2886-2895 (2018). "Spectral decomposition for resolving partial volume
effects in MRSI".
}
