% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NEW_k_functions_sf.R
\name{cross_kfunctions.mc}
\alias{cross_kfunctions.mc}
\title{Network cross k and g functions (maturing, multicore)}
\usage{
cross_kfunctions.mc(
  lines,
  pointsA,
  pointsB,
  start,
  end,
  step,
  width,
  nsim,
  conf_int = 0.05,
  digits = 2,
  tol = 0.1,
  resolution = NULL,
  agg = NULL,
  verbose = TRUE,
  return_sims = FALSE,
  calc_g_func = TRUE,
  grid_shape = c(1, 1)
)
}
\arguments{
\item{lines}{A feature collection of linestrings representing the underlying network. The
geometries must be simple Linestrings (may crash if some geometries
are invalid) without MultiLineSring}

\item{pointsA}{A feature collection of points representing the points to which the
distances are calculated.}

\item{pointsB}{A feature collection of points representing the points from which
the distances are calculated.}

\item{start}{A double, the lowest distance used to evaluate the k and g functions}

\item{end}{A double, the highest distance used to evaluate  the k and g functions}

\item{step}{A double, the step between two evaluations of the k and g
function. start, end and step are used to create a vector of distances with the function seq}

\item{width}{The width of each donut for the g-function. Half of the width is applied on
both sides of the considered distance}

\item{nsim}{An integer indicating the number of Monte Carlo simulations
to perform for inference}

\item{conf_int}{A double indicating the width confidence interval (default =
0.05) calculated on the Monte Carlo simulations}

\item{digits}{An integer indicating the number of digits to retain from the
spatial coordinates}

\item{tol}{When adding the points to the network, specify the minimum
distance between these points and the lines' extremities. When points are
closer, they are added at the extremity of the lines}

\item{resolution}{When simulating random points on the network, selecting a
resolution will reduce greatly the calculation time. When resolution is null
the random points can occur everywhere on the graph. If a value is specified,
the edges are split according to this value and the random points can only be
vertices on the new network}

\item{agg}{A double indicating if the events must be aggregated within a distance.
If NULL, the events are aggregated only by rounding the coordinates}

\item{verbose}{A Boolean indicating if progress messages should be displayed}

\item{return_sims}{a boolean indicating if the simulated k and g values must also
be returned.}

\item{calc_g_func}{A Boolean indicating if the G function must also be calculated (TRUE by default). If FALSE, then only the K function is calculated}

\item{grid_shape}{A vector of two values indicating how the study area
must be split when performing the calculus. Default is c(1,1) (no split). A finer grid could
reduce memory usage and increase speed when a large dataset is used. When using
multiprocessing, the work in each grid is dispatched between the workers.}
}
\value{
A list with the following values : \cr \item{plotk}{ A
ggplot2 object representing the values of the cross k-function}
\item{plotg}{ A ggplot2 object representing the values of the cross
g-function} \item{values}{ A DataFrame with the values used to build the
plots}
}
\description{
Calculate the cross k and g functions for a set of points on a
network. For more details, see the document of the function cross_kfunctions.
}
\examples{
\donttest{
data(main_network_mtl)
data(mtl_libraries)
data(mtl_theatres)
future::plan(future::multisession(workers=1))
result <- cross_kfunctions.mc(main_network_mtl, mtl_theatres, mtl_libraries,
                           start = 0, end = 2500, step = 10, width = 250,
                           nsim = 50, conf_int = 0.05, digits = 2,
                           tol = 0.1, agg = NULL, verbose = FALSE)
}
}
