% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_simultaneous_tnkde_bw.R
\name{adaptive_bw_tnkde}
\alias{adaptive_bw_tnkde}
\title{Adaptive bandwidth for TNDE}
\usage{
adaptive_bw_tnkde(
  grid,
  events_loc,
  events,
  lines,
  bw_net,
  bw_time,
  trim_bw_net,
  trim_bw_time,
  method,
  kernel_name,
  max_depth,
  div,
  tol,
  digits,
  sparse,
  verbose
)
}
\arguments{
\item{grid}{A spatial grid to split the data within}

\item{events}{A feature collection of points representing the events points}

\item{lines}{A feature collection of linestrings representing the network}

\item{bw_net}{The fixed kernel bandwidth for the network dimension}

\item{bw_time}{The fixed kernel bandwidth for the time dimension}

\item{trim_bw_net}{The maximum size of local bandiwidths for network dimension}

\item{trim_bw_time}{The maximum size of local bandiwidths for time dimension}

\item{method}{The method to use when calculating the NKDE}

\item{kernel_name}{The name of the kernel to use}

\item{max_depth}{The maximum recursion depth}

\item{div}{The divisor to use for kernels}

\item{tol}{A float indicating the spatial tolerance when snapping events on
lines}

\item{digits}{The number of digits to keep}

\item{sparse}{A Boolean indicating if sparse matrix should be used}

\item{verbose}{A Boolean indicating if update messages should be printed}
}
\value{
A vector with the local bandwidths
}
\description{
Function to calculate Adaptive bandwidths according to Abramson’s smoothing regimen
for TNKDE with a space-time interaction.
}
\examples{
#This is an internal function, no example provided
}
\keyword{internal}
