% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbouring.R
\name{network_listw_worker}
\alias{network_listw_worker}
\title{network_listw worker}
\usage{
network_listw_worker(
  points,
  lines,
  maxdistance,
  dist_func,
  direction = NULL,
  mindist = 10,
  matrice_type = "B",
  verbose = FALSE,
  digits = 3,
  tol = 0.1
)
}
\arguments{
\item{points}{A SpatialPointsDataFrame corresponding to start and end
points. It must have a column fid, grouping the points if necessary.}

\item{lines}{A SpatialLinesDataFrame representing the network}

\item{maxdistance}{The maximum distance between two observation to
consider them as neighbours.}

\item{dist_func}{A vectorized function converting spatial distances into
weights.}

\item{direction}{Indicate a field giving information about authorized
travelling direction on lines. if NULL, then all lines can be used in both
directions. Must be the name of a column otherwise. The values of the
column must be "FT" (From - To), "TF" (To - From) or "Both".}

\item{mindist}{The minimum distance between two different observations.
It is important for it to be different from 0 when a W style is used.}

\item{matrice_type}{The type of the weighting scheme. Can be 'B' for Binary,
'W' for row weighted, see the documentation of spdep::nb2listw for details}

\item{verbose}{A Boolean indicating if the function should print its
progress}

\item{digits}{the number of digits to keep in the spatial coordinates (
simplification used to reduce risk of topological error)}

\item{tol}{A float indicating the spatial tolerance when points are
added as vertices to lines.}
}
\value{
A list of neihbours as weights.
}
\description{
The worker function of network_listw.
}
\examples{
#no example provided, this is an internal function
}
\keyword{internal}
