# taken from subset.data.frame:
subset.Spatial = function(x, subset, select, drop = FALSE, ...) {
    if (missing(subset))
        r <- TRUE
    else {
		if (is.logical(subset) && missing(select))
			return(x[subset & !is.na(subset),])
        e <- substitute(subset)
        r <- eval(e, x@data, parent.frame())
        if (!is.logical(r)) 
            stop("'subset' must evaluate to logical")
        r <- r & !is.na(r)
    }
    if (missing(select)) 
        vars <- TRUE
    else {
        nl <- as.list(seq_along(x@data))
        names(nl) <- names(x@data)
        vars <- eval(substitute(select), nl, parent.frame())
    }
    x[r, vars, drop = drop]
}
