% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regimes.R
\name{regimes}
\alias{regimes}
\title{Identify regimes via unsupervised ML algorithms}
\usage{
regimes(data, method = "rf", regime.n = NULL)
}
\arguments{
\item{data}{data.frame, matrix, ts, xts, zoo: Endogenous regressors}

\item{method}{string: regime assignment technique ('rf', 'kmeans', 'EM', or 'BP)}

\item{regime.n}{int: number of regimes to estimate (applies to kmeans and EM)}
}
\value{
\code{data} as a data.frame with a regime column assigning rows to mutually exclusive regimes
}
\description{
Regime assignment (clustering) methods available include the
\href{https://www.rdocumentation.org/packages/randomForest/versions/4.6-14/topics/randomForest}{unsupervised random forest},
\href{https://www.rdocumentation.org/packages/stats/versions/3.6.2/topics/kmeans}{k-mean clustering},
Fraley and Raftery Model-based clustering \href{https://www.rdocumentation.org/packages/mclust/versions/5.4.7/topics/Mclust}{EM algorithm},
and the \href{https://www.rdocumentation.org/packages/strucchange/versions/1.5-2/topics/breakpoints}{Bai & Perron (2003)} method for simultaneous estimation of multiple breakpoints.
}
\examples{
\donttest{

 # simple time series
 AA = c(1:100) + rnorm(100)
 BB = c(1:100) + rnorm(100)
 CC = AA + BB + rnorm(100)
 date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
 Data = data.frame(date = date, AA, BB, CC)

 # estimate reigme
 regime =
  sovereign::regimes(
     data = Data,
     method = 'kmeans',
     regime.n = 3)
}

}
