% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modulationSpectrum.R
\name{.modulationSpectrum}
\alias{.modulationSpectrum}
\title{Modulation spectrum per sound}
\usage{
.modulationSpectrum(
  audio,
  specSource = c("STFT", "audSpec")[1],
  windowLength = 15,
  step = 1,
  wn = "hanning",
  zp = 0,
  audSpec_pars = list(filterType = "butterworth", nFilters = 32, bandwidth = 1/24, yScale
    = "bark", dynamicRange = 120),
  msType = c("1D", "2D")[2],
  amRes = 5,
  maxDur = 5,
  specMethod = c("spec", "meanspec")[2],
  logSpec = FALSE,
  logMPS = FALSE,
  power = 1,
  normalize = TRUE,
  roughRange = c(30, 150),
  roughMean = NULL,
  roughSD = NULL,
  roughMinFreq = 1,
  amRange = c(10, 200),
  returnMS = TRUE,
  returnComplex = FALSE,
  plot = TRUE,
  savePlots = NULL,
  logWarpX = NULL,
  logWarpY = NULL,
  quantiles = c(0.5, 0.8, 0.9),
  kernelSize = 5,
  kernelSD = 0.5,
  colorTheme = c("bw", "seewave", "heat.colors", "...")[1],
  col = NULL,
  main = NULL,
  xlab = "Hz",
  ylab = "1/kHz",
  xlim = NULL,
  ylim = NULL,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{specSource}{'STFT' = Short-Time Fourier Transform; 'audSpec' = a bank
of bandpass filters (see \code{\link{audSpectrogram}})}

\item{windowLength, step, wn, zp}{parameters for extracting a spectrogram if
\code{specType = 'STFT'}. Window length and step are specified in ms (see
\code{\link{spectrogram}}). If \code{specType = 'audSpec'}, these settings
have no effect}

\item{audSpec_pars}{parameters for extracting an auditory spectrogram if
\code{specType = 'audSpec'}. If \code{specType = 'STFT'}, these settings
have no effect}

\item{msType}{'2D' = two-dimensional Fourier transform of a spectrogram; '1D'
= separately calculated spectrum of each frequency band}

\item{amRes}{target resolution of amplitude modulation, Hz. If \code{NULL},
the entire sound is analyzed at once, resulting in a single roughness value
(unless it is longer than \code{maxDur}, in which case it is analyzed in
chunks \code{maxDur} s long). If \code{amRes} is set, roughness is
calculated for windows \code{~1000/amRes} ms long (but at least 3 STFT
frames). \code{amRes} also affects the amount of smoothing when calculating
\code{amMsFreq} and \code{amMsPurity}}

\item{maxDur}{sounds longer than \code{maxDur} s are split into fragments,
and the modulation spectra of all fragments are averaged}

\item{specMethod}{the function to call when calculating the spectrum of each
frequency band (only used when \code{msType = '1D'}); 'meanspec' is faster
and less noisy, whereas 'spec' produces higher resolution}

\item{logSpec}{if TRUE, the spectrogram is log-transformed prior to taking 2D
FFT}

\item{logMPS}{if TRUE, the modulation spectrum is log-transformed prior to
calculating roughness}

\item{power}{raise modulation spectrum to this power (eg power = 2 for ^2, or
"power spectrum")}

\item{normalize}{if TRUE, the modulation spectrum of each analyzed fragment
\code{maxDur} in duration is separately normalized to have max = 1}

\item{roughRange}{the range of temporal modulation frequencies that
constitute the "roughness" zone, Hz}

\item{roughMean, roughSD}{the mean (Hz) and standard deviation (semitones) of
a lognormal distribution used to weight roughness estimates. If either is
null, roughness is calculated simply as the proportion of spectrum within
\code{roughRange}. If both \code{roughMean} and \code{roughRange} are
defined, weights outside \code{roughRange} are set to 0; a very large SD (a
flat weighting function) gives the same result as just \code{roughRange}
without any weighting (see examples)}

\item{roughMinFreq}{frequencies below roughMinFreq (Hz) are ignored when
calculating roughness (ie the estimated roughness increases if we disregard
very low-frequency modulation, which is often strong)}

\item{amRange}{the range of temporal modulation frequencies that we are
interested in as "amplitude modulation" (AM), Hz}

\item{returnMS}{if FALSE, only roughness is returned (much faster). Careful
with exporting the modulation spectra of a lot of sounds at once as this
requires a lot of RAM}

\item{returnComplex}{if TRUE, returns a complex modulation spectrum (without
normalization and warping)}

\item{plot}{if TRUE, plots the modulation spectrum of each sound (see
\code{\link{plotMS}})}

\item{savePlots}{if a valid path is specified, a plot is saved in this folder
(defaults to NA)}

\item{logWarpX, logWarpY}{numeric vector of length 2: c(sigma, base) of
pseudolog-warping the modulation spectrum, as in function
pseudo_log_trans() from the "scales" package}

\item{quantiles}{labeled contour values, \% (e.g., "50" marks regions that
contain 50\% of the sum total of the entire modulation spectrum)}

\item{kernelSize}{the size of Gaussian kernel used for smoothing (1 = no
smoothing)}

\item{kernelSD}{the SD of Gaussian kernel used for smoothing, relative to its
size}

\item{colorTheme}{black and white ('bw'), as in seewave package ('seewave'),
matlab-type palette ('matlab'), or any palette from
\code{\link[grDevices]{palette}} such as 'heat.colors', 'cm.colors', etc}

\item{col}{actual colors, eg rev(rainbow(100)) - see ?hcl.colors for colors
in base R (overrides colorTheme)}

\item{xlab, ylab, main, xlim, ylim}{graphical parameters}

\item{width, height, units, res}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{...}{other graphical parameters passed on to \code{filled.contour.mod}
and \code{\link[graphics]{contour}} (see \code{\link{spectrogram}})}
}
\description{
Internal soundgen function.
}
\keyword{internal}
