% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundgen_utilities.R
\name{scaleNoiseAnchors}
\alias{scaleNoiseAnchors}
\title{Scale noise anchors}
\usage{
scaleNoiseAnchors(noiseTime, sylLen_old, sylLen_new)
}
\arguments{
\item{noiseTime}{vector of time points at which noise anchors are defined}

\item{sylLen_old}{syllable length relative to which the timing of noise anchors is
specified}

\item{sylLen_new}{the new syllable length}
}
\description{
Internal soundgen function.
}
\details{
Scales a dataframe containing noise anchors so as to preserve the timing of
positive anchors relative to the new syllable duration. Negative time anchors
are not changed: the pre-aspiration length is constant, regardless of the
actual syllable duration. Time anchors from 0 to sylLen are proportional to
the actual syllable duration re the average expected duration (which the user
sees in the UI when choosing time anchors). Time anchors beyond sylLen are
scaled to preserve post-aspiration duration.
}
\examples{
noiseTime = c(-20, 50, 120)
soundgen:::scaleNoiseAnchors(noiseTime, sylLen_old = 100, sylLen_new = 200)
soundgen:::scaleNoiseAnchors(noiseTime, sylLen_old = 100, sylLen_new = 50)
soundgen:::scaleNoiseAnchors(noiseTime, sylLen_old = 200, sylLen_new = 300)
}
\keyword{internal}
