% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noiseRemoval.R
\name{noiseRemoval}
\alias{noiseRemoval}
\title{Noise removal}
\usage{
noiseRemoval(
  x,
  samplingRate = NULL,
  scale = NULL,
  noise,
  dB = 6,
  specificity = 1,
  windowLength = 50,
  step = windowLength/2,
  dynamicRange = 120,
  normalize = c("max", "orig", "none")[2],
  reportEvery = NULL,
  cores = 1,
  play = FALSE,
  saveAudio = NULL,
  plot = FALSE,
  savePlots = NULL,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)
}
\arguments{
\item{x}{path to a folder, one or more wav or mp3 files c('file1.wav',
'file2.mp3'), Wave object, numeric vector, or a list of Wave objects or
numeric vectors}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{scale}{maximum possible amplitude of input used for normalization of
input vector (only needed if \code{x} is a numeric vector)}

\item{noise}{a numeric vector of length two specifying the location of pure
noise in input audio (in s); a matrix representing pure noise as a spectrum
with frequency bins in rows; any input accepted by
\code{\link{spectrogram}} if pure noise is found in a separate recording
(eg path to file, numeric vector, etc.)}

\item{dB}{if NULL (default), the spectral envelope is applied on the original
scale; otherwise, it is set to range from 1 to 10 ^ (dB / 20)}

\item{specificity}{a way to sharpen or blur the noise spectrum (we take noise
spectrum ^ specificity) : 1 = no change, >1 = sharper (the loudest noise
frequencies are preferentially removed), <1 = blurred (even quiet noise
frequencies are removed)}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms (NB:
because digital audio is sampled at discrete time intervals of
1/samplingRate, the actual step and thus the time stamps of STFT frames
may be slightly different, eg 24.98866 instead of 25.0 ms)}

\item{dynamicRange}{dynamic range, dB. All values more than one dynamicRange
under maximum are treated as zero}

\item{normalize}{if TRUE, scales input prior to FFT}

\item{reportEvery}{when processing multiple inputs, report estimated time
left every ... iterations (NULL = default, NA = don't report)}

\item{cores}{number of cores for parallel processing}

\item{play}{if TRUE, plays the synthesized sound using the default player on
your system. If character, passed to \code{\link[tuneR]{play}} as the name
of player to use, eg "aplay", "play", "vlc", etc. In case of errors, try
setting another default player for \code{\link[tuneR]{play}}}

\item{saveAudio}{path + filename for saving the output, e.g.
'~/Downloads/temp.wav'. If NULL = doesn't save}

\item{plot}{should a spectrogram be plotted? TRUE / FALSE}

\item{savePlots}{full path to the folder in which to save the plots (NULL =
don't save, '' = same folder as audio)}

\item{width, height, units, res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{...}{other graphical parameters}
}
\value{
Returns the denoised audio
}
\description{
Removes noise by spectral substraction. If a recording is affected by a
steady noise with a relatively stable amplitude and spectrum (e.g.,
microphone hiss, crickets, MRI buzz, etc.), its spectrum can be simply
subtracted from the signal. Algorithm: STFT to produce a spectrogram, divide
by normalized noise spectrum, inverse STFT to reconstitute the signal. Most
of the work is done by \code{\link{addFormants}}.
}
\examples{
s = soundgen(noise = list(time = c(-100, 400), value = -20),
  formantsNoise = list(f1 = list(freq = 3000, width = 25)),
  addSilence = 50, temperature = .001, plot = TRUE)
# Option 1: use part of the recording as noise profile
s1 = noiseRemoval(s, samplingRate = 16000, noise = c(0.05, 0.15),
  dB = 40, plot = TRUE)

# Option 2: use a separate recording as noise profile
noise = soundgen(pitch = NA, noise = 0,
  formantsNoise = list(f1 = list(freq = 3000, width = 25)))
spectrogram(noise, 16000)
s2 = noiseRemoval(s, samplingRate = 16000, noise = noise,
  dB = 40, plot = TRUE)

# Option 3: provide noise spectrum as a matrix
spec_noise = spectrogram(
      noise, samplingRate = 16000,
      output = 'original', plot = FALSE)
s3 = noiseRemoval(s, samplingRate = 16000, noise = spec_noise,
  dB = 40, plot = TRUE)

\dontrun{
# play with gain and sensitivity
noiseRemoval(s, samplingRate = 16000, noise = c(0.05, 0.15),
  dB = 60, specificity = 2, plot = TRUE)

# remove noise only from a section of the audio
noiseRemoval(s, samplingRate = 16000, from = .3, to = .4,
  noise = c(0.05, 0.15), dB = 60, plot = TRUE, play = TRUE)
}
}
\seealso{
\code{\link{addFormants}}
}
