% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundgen_utilities.R
\name{objectToString}
\alias{objectToString}
\title{Object to string}
\usage{
objectToString(x)
}
\arguments{
\item{x}{any R object (unquoted)}
}
\description{
Internal soundgen function. Converts any object to a string that preserves all internal structure and names.
}
\examples{
soundgen:::objectToString('adja')
soundgen:::objectToString(500)
soundgen:::objectToString(c(870, 1250, 1900))
soundgen:::objectToString(list(f1 = c(870, 1250), f2 = list(freq = 500, amp = 30)))
soundgen:::objectToString(list(
  pitch = list(time = c(0, 1), value = c(160, 150)),
  noise = list(time = c(-1, 170, 362), value = c(-14, 0, -26)),
  mouth = list(time = c(0, 0.07, 1), value = c(0, 0.48, 0.32))))
# NB: no matter how long, the object is still returned as an unbroken string
}
\keyword{internal}
