% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invertModulSpec.R
\name{.filterSoundByMS}
\alias{.filterSoundByMS}
\title{Filter a single sound by MS}
\usage{
.filterSoundByMS(
  audio,
  logSpec = FALSE,
  windowLength = 25,
  step = NULL,
  overlap = 80,
  wn = "hamming",
  zp = 0,
  amCond = NULL,
  fmCond = NULL,
  jointCond = NULL,
  action = c("remove", "preserve")[1],
  initialPhase = c("zero", "random", "spsi")[3],
  nIter = 50,
  play = FALSE,
  plot = TRUE,
  savePlots = NULL,
  width = 900,
  height = 500,
  units = "px",
  res = NA
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{logSpec}{if TRUE, the spectrogram is log-transformed prior to taking 2D
FFT}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms (NB:
because digital audio is sampled at discrete time intervals of
1/samplingRate, the actual step and thus the time stamps of STFT frames
may be slightly different, eg 24.98866 instead of 25.0 ms)}

\item{overlap}{overlap between successive FFT frames, \%}

\item{wn}{window type accepted by \code{\link[seewave]{ftwindow}}, currently
gaussian, hanning, hamming, bartlett, rectangular, blackman, flattop}

\item{zp}{window length after zero padding, points}

\item{amCond}{character strings with valid conditions on amplitude and
frequency modulation (see examples)}

\item{fmCond}{character strings with valid conditions on amplitude and
frequency modulation (see examples)}

\item{jointCond}{character string with a valid joint condition amplitude and
frequency modulation}

\item{action}{should the defined AM-FM region be removed ('remove') or
preserved, while everything else is removed ('preserve')?}

\item{initialPhase}{initial phase estimate: "zero" = set all phases to zero;
"random" = Gaussian noise; "spsi" (default) = single-pass spectrogram
inversion (Beauregard et al., 2015)}

\item{nIter}{the number of iterations of the GL algorithm (Griffin & Lim,
1984), 0 = don't run}

\item{play}{if TRUE, plays back the reconstructed audio}

\item{plot}{if TRUE, produces a triple plot: original MS, filtered MS, and
the MS of the output sound}

\item{savePlots}{if a valid path is specified, a plot is saved in this folder
(defaults to NA)}

\item{width}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{height}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{units}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{res}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}
}
\description{
Internal soundgen function.
}
\keyword{internal}
