% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_pitch_postprocessing.R
\name{findInflections}
\alias{findInflections}
\title{Find inflections}
\usage{
findInflections(x, thres = NULL, step = NULL, plot = FALSE, main = "")
}
\arguments{
\item{x}{numeric vector with or without NAs}

\item{thres}{minimum vertical distance between two extrema for them to count
as two independent inflections}

\item{step}{distance between values in s (only needed for plotting)}

\item{plot}{if TRUE, produces a simple plot}

\item{main}{plot title}
}
\value{
Returns a vector of indices giving the location of inflections.
}
\description{
Finds inflections in discrete time series such as pitch contours. When there
are no missing values and no thresholds, this can be accomplished with a fast
one-liner like \code{which(diff(diff(x) > 0) != 0) + 1}. Missing values are
interpolated by repeating the first and last non-missing values at the head
and tail, respectively, and by linear interpolation in the middle. Setting a
threshold means that small "wiggling" no longer counts. To use an analogy
with ocean waves, smoothing (low-pass filtering) removes the ripples and only
leaves the slow roll, while thresholding preserves only waves that are
sufficiently high, whatever their period.
}
\examples{
x = sin(2 * pi * (1:100) / 15) * seq(1, 5, length.out = 100)
idx_na = c(1:4, 6, 7, 14, 25, 30:36, 39, 40, 42, 45:50,
           57, 59, 62, 66, 71:79, 98)
x[idx_na] = NA
soundgen:::findInflections(x, plot = TRUE)
soundgen:::findInflections(x, thres = 5, plot = TRUE)

for (i in 1:10) {
  temp = soundgen:::getRandomWalk(len = runif(1, 10, 100), rw_range = 10,
                                  rw_smoothing = runif(1, 0, 1))
  soundgen:::findInflections(temp, thres = 1, plot = TRUE)
  invisible(readline(prompt="Press [enter] to continue"))
}
}
