% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_analyze.R
\name{upsamplePitchContour}
\alias{upsamplePitchContour}
\title{Upsample pitch contour}
\usage{
upsamplePitchContour(pitch, len, plot = FALSE)
}
\arguments{
\item{pitch}{numeric vector of pitch values, including NAs (as returned by
pitch_app)}

\item{len}{required length}

\item{plot}{if TRUE, plots the old and new pitch contours}
}
\description{
Internal soundgen function
}
\details{
Intended to up- or downsample pitch contours containing NA values using
linear interpolation ("approx"). The problem is that NA segments should also
be expanded when upsampling, and approx() doesn't do that. Algorithm: when
upsampling, first interpolates NAs (constant at beg/end, linear in the
middle), then runs approx(), and finally puts NAs back in where they belong.
}
\examples{
pitchManual = c(130, 150, 250, 290, 320, 300, 280, 270, 220)
soundgen:::upsamplePitchContour(pitchManual, len = 5, plot = TRUE)
soundgen:::upsamplePitchContour(pitchManual, len = 25, plot = TRUE)

pitchManual = c(NA, 150, 250, NA, NA, 300, 280, 270, NA)
soundgen:::upsamplePitchContour(pitchManual, len = 5, plot = TRUE)
soundgen:::upsamplePitchContour(pitchManual, len = 25, plot = TRUE)

soundgen:::upsamplePitchContour(c(NA, NA), len = 5)
}
\keyword{internal}
