% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrogram.R
\name{ftwindow_modif}
\alias{ftwindow_modif}
\title{Fourier transform windows (seewave)}
\usage{
ftwindow_modif(wl, wn = "gaussian")
}
\arguments{
\item{wl}{window length, in points}

\item{wn}{window type (defaults to gaussian)}
}
\description{
Internal soundgen function
}
\details{
Generates different Fourier Transform windows. Just like
\code{\link[seewave]{ftwindow}}, but with the addition of a gaussian window.
}
\examples{
wns = c('bartlett', 'blackman', 'flattop', 'hamming', 'hanning', 'rectangle', 'gaussian')
l = 16
par(mfrow = c(4, 2))
for (w in wns) {
  plot(1:l, soundgen:::ftwindow_modif(wl = l, wn = w), type = 'b', main = w)
}
par(mfrow = c(1, 1))
}
\keyword{internal}
