% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplitude.R
\name{getRMS}
\alias{getRMS}
\title{RMS amplitude per frame}
\usage{
getRMS(x, samplingRate = NULL, windowLength = 50, step = NULL,
  overlap = 75, killDC = FALSE, scale = NULL, normalize = TRUE,
  windowDC = 200, plot = TRUE, xlab = "Time, ms", ylab = "",
  type = "b", col = "blue", lwd = 2, ...)
}
\arguments{
\item{x}{path to a .wav or .mp3 file or a vector of amplitudes with specified
samplingRate}

\item{samplingRate}{sampling rate of \code{x} (only needed if
\code{x} is a numeric vector, rather than an audio file)}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}

\item{overlap}{overlap between successive FFT frames, \%}

\item{killDC}{if TRUE, removed DC offset (see also \code{\link{flatEnv}})}

\item{scale}{maximum possible amplitude of input used for normalization (not
needed for audio files)}

\item{normalize}{if TRUE, RMS amplitude is normalized to [0, 1]}

\item{windowDC}{the window for calculating DC offset, ms}

\item{plot}{should a spectrogram be plotted? TRUE / FALSE}

\item{xlab, ylab}{general graphical parameters}

\item{type, col, lwd}{graphical parameters pertaining to the RMS envelope}

\item{...}{other graphical parameters}
}
\value{
Returns a numeric vector of RMS amplitudes per frame on the scale of
  input. Names give time stamps for the center of each frame, in ms.
}
\description{
Calculates root mean square (RMS) amplitude in overlapping frames, providing
an envelope of RMS amplitude as a measure of sound intensity. Longer windows
provide smoother, more robust estimates; shorter windows and more overlap
improve temporal resolution, but they also increase processing time and make
the contour less smooth.
}
\details{
Note that you can also get similar estimates per frame from
\code{\link{analyze}} on a normalized scale of 0 to 1, but \code{getRMS} is
much faster, operates on the original scale, and plots the amplitude contour.
If you need RMS for the entire sound instead of per frame, you can simply
calculate it as \code{sqrt(mean(x^2))}, where \code{x} is your waveform.
Having RMS estimates per frame gives more flexibility: RMS per sound can be
calculated as the mean / median / max of RMS values per frame.
}
\examples{
s = soundgen() + .1  # with added DC offset
plot(s, type = 'l')
r = getRMS(s, samplingRate = 16000,
  windowLength = 40, overlap = 50, killDC = TRUE,
  col = 'green', lty = 2, main = 'RMS envelope')
# short window = jagged envelope
r = getRMS(s, samplingRate = 16000,
  windowLength = 5, overlap = 0, killDC = TRUE,
  col = 'green', lty = 2, main = 'RMS envelope')
\dontrun{
r = getRMS('~/Downloads/temp/032_ut_anger_30-m-roar-curse.wav')
}
}
