% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_math.R
\name{HzToSemitones}
\alias{HzToSemitones}
\title{Convert Hz to semitones}
\usage{
HzToSemitones(h)
}
\arguments{
\item{h}{vector or matrix of frequencies (Hz)}
}
\description{
Converts from Hz to semitones above C0 (~16.4 Hz). This may not seem very
useful, but note that (1) this gives you a nice logarithmic scale for
generating natural pitch transitions, (2) with the added benefit of getting
musical notation for free from \code{notesDict} (see examples).
}
\examples{
s = HzToSemitones(c(440, 293, 115))
# to convert to musical notation
notesDict$note[1 + round(s)]
# note the "1 +": semitones ABOVE C0, i.e. notesDict[1, ] is C0
}
