% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{coocc}
\alias{coocc}
\title{Generate a contingency table of co-occurrences of sound correspondences with themselves, or with metadata.}
\usage{
coocc(data, column, count, unit)
}
\arguments{
\item{data}{[soundcorrs] The dataset from which to draw frequencies. Only datasets with two languages are supported.}

\item{column}{[character] Name of the column with metadata. If \code{NULL}, sound correspondences are cross-tabulated with themselves. Defaults to \code{NULL}.}

\item{count}{[character] Report the absolute number of times or words, or relative to how many times or in how many words the given segments co-occur in L1 or L2. Accepted values are \code{"a(bs(olute))"} and \code{"r(el(ative))"}. Defaults to "a".}

\item{unit}{[character] Count how many times a correspondence occurs or in how many words it occurs. Accepted values are \code{"o(cc(ur(ence(s))))"} and \code{"w(or(d(s)))"}. Defaults to \code{"w"}.}
}
\value{
[table] The contingency table. The values represent how often the given correspondence co-occurs in the same word with the other correspondence or with the piece of metadata (cf. \code{\link{summary}}).
}
\description{
Take all segment-to-segment correspondences in a dataset, and cross-tabulate them with themselves or with metadata taken from a separate column.
}
\examples{
dataset <- sampleSoundCorrsData.abc
coocc (dataset)
coocc (dataset, "DIALECT.L2")
round (coocc(dataset,"DIALECT.L2",count="r"), digits=3)
}
\seealso{
\code{\link{summary}}, \code{\link{allCooccs}}.
}
