% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetDataSotkanet.R
\name{GetDataSotkanet}
\alias{GetDataSotkanet}
\title{Retrieve Sotkanet Data}
\usage{
GetDataSotkanet(
  indicators,
  years = 1991:2015,
  genders = c("total"),
  regions = NULL,
  region.category = NULL,
  verbose = TRUE
)
}
\arguments{
\item{indicators}{Dataset identifier(s)}

\item{years}{vector of years c(2010, 2012, ... )}

\item{genders}{vector of genders ('male' | 'female' | 'total')}

\item{regions}{pick selected regions only (default: all regions)}

\item{region.category}{return selected regions category (for options, see:
     unique(SotkanetRegions(type = "table")$region.category)); 
"ALUEHALLINTOVIRASTO, "ELY-KESKUS", "ERVA", "EURALUEET", "EUROOPPA", 
"HYVINVOINTIALUE", "KUNTA", "MAA", "MAAKUNTA", "NUTS1", "POHJOISMAAT", 
"SAIRAANHOITOPIIRI", "SEUTUKUNTA", "SUURALUE"}

\item{verbose}{verbose}
}
\value{
data.frame
}
\description{
Retrieve selected data and combine into a single table.
}
\examples{
\dontrun{dat <- GetDataSotkanet(indicators = 165)}
}
\references{
See citation("sotkanet")
}
\author{
Maintainer: Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{utilities}
