############################################################################## #
# Copyright (C) 2019 by 52 North                                               #
# Initiative for Geospatial Open Source Software GmbH                          #
#                                                                              #
# Contact: Andreas Wytzisk                                                     #
# 52 North Initiative for Geospatial Open Source Software GmbH                 #
# Martin-Luther-King-Weg 24                                                    #
# 48155 Muenster, Germany                                                      #
# info@52north.org                                                             #
#                                                                              #
# This program is free software; you can redistribute and/or modify it under   #
# the terms of the GNU General Public License version 2 as published by the    #
# Free Software Foundation.                                                    #
#                                                                              #
# This program is distributed WITHOUT ANY WARRANTY; even without the implied   #
# WARRANTY OF MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU #
# General Public License for more details.                                     #
#                                                                              #
# You should have received a copy of the GNU General Public License along with #
# this program (see gpl-2.0.txt). If not, write to the Free Software           #
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA or #
# visit the Free Software Foundation web page, http://www.fsf.org.             #
#                                                                              #
# Author: Daniel Nuest (daniel.nuest@uni-muenster.de)                          #
# Created: 2010-06-18                                                          #
# Project: sos4R - https://github.com/52North/sos4R                            #
#                                                                              #
############################################################################## #

#
# construction methods
#
SwePhenomenon <- function(id, name, description = as.character(NA)) {
  new("SwePhenomenon", id = id, name = name, description = description)
}

SweCompositePhenomenon <- function(id, name, description = as.character(NA),
                                   dimension, components, base = NULL) {
  new("SweCompositePhenomenon", id = id, name = name,
      description = description, dimension = dimension,
      components = components, base = base)	
}

SwePhenomenonProperty <- function(href = as.character(NA), phenomenon = NULL) {
  new("SwePhenomenonProperty", href = href, phenomenon = phenomenon)
}

SweTextBlock <- function(tokenSeparator, blockSeparator, decimalSeparator,
                         id = as.character(NA)) {
  new("SweTextBlock", tokenSeparator = tokenSeparator,
      blockSeparator = blockSeparator,
      decimalSeparator = decimalSeparator, id = id)
}