% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assoc.lib.R
\name{annotateSNPs}
\alias{annotateSNPs}
\title{Annotate SNPs}
\usage{
annotateSNPs(x, mode = c("significant", "top", "all"), alpha = 0.05,
  num.top = 10, query.size = 500, verbose = 0)
}
\arguments{
\item{x}{An object of class \code{solarAssoc} or a character vector of SNPs.}

\item{mode}{A character with the mode of SNPs selection.
Possible values are \code{"significant"}, \code{"top"} and \code{"all"}.
The default value is \code{"significant"}.}

\item{alpha}{A numeric value from 0 to 1, the significance level after Bonferroni multiple-test correction.
Corresponds to \code{mode} equal to \code{"significant"}.}

\item{num.top}{An integer value, the number of top SNPs to be annotated.
Corresponds to \code{mode} equal to \code{"top"}.
The default value is 10.}

\item{query.size}{An integer, the maximum number of SNPs allowed for a single query to the NCBI database.
The default value is \code{500}.
See also the help page for \code{NCBI_snp_query} function in \code{rsnps} package.
If the number of SNPs is greater than \code{query.size},
then the query is split into batches automatically.}

\item{verbose}{An integer, the verbose level.
The default value is \code{0}.}

\item{...}{Additional arguments.}
}
\value{
A data table with annotation results.
}
\description{
The function annotates SNPs based on \code{NCBI2R} R package,
in particular \code{AnnotateSNPList} function.
}
\details{
See \url{https://ncbi2r.wordpress.com/} for more details.
}

