% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waterDayYear.R
\name{waterDayYear}
\alias{waterDayYear}
\title{Compute Water Day and Year}
\usage{
waterDayYear(d, end = "09-30", format = "\%Y-\%m-\%d", tz = "")
}
\arguments{
\item{d}{anything the can be safely converted to \code{POSIXlt}}

\item{end}{"MM-DD" notation for end of water year}

\item{format}{Used in POSIXlt conversion. Default \code{"\%Y-\%m-\%d"}}

\item{tz}{Used in POSIXlt conversion for custom timezone. Default \code{""} is current locale}
}
\value{
A \code{data.frame} object with the following \item{wy}{the "water
year"} \item{wd}{the "water day"}
}
\description{
Compute "water" day and year, based on the end of the typical or legal dry
season. This is September 30 in California.
}
\details{
This function doesn't know about leap-years. Probably worth checking.
}
\examples{

# try it
waterDayYear('2019-01-01')

}
\references{
Ideas borrowed from:
\url{https://github.com/USGS-R/dataRetrieval/issues/246} and
\url{https://stackoverflow.com/questions/48123049/create-day-index-based-on-water-year}
}
\author{
D.E. Beaudette
}
\keyword{manip}
