% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/softermax.R
\name{softermax}
\alias{softermax}
\alias{softermax.experiment}
\alias{softermax.plate}
\alias{softermax.note}
\alias{softermax.wavelength}
\alias{softermax.well}
\alias{softermax.template}
\title{Create softermax Objects}
\usage{
softermax(experiments = list(), attrs = list())

softermax.experiment(name, plates = list(), notes = list(),
  attrs = list())

softermax.plate(name, wavelengths = list(), temperatures = NULL,
  attrs = list())

softermax.note(name, text_data = list(), attrs = list())

softermax.wavelength(wavelength, wells = list(), attrs = list())

softermax.well(name, times, values, attrs = list())

softermax.template(x, wellsAsFactors = TRUE, groupsAsFactors = TRUE,
  typesAsFactors = TRUE)
}
\arguments{
\item{experiments}{A list of \code{softermax.experiment} objects}

\item{attrs}{A list of attributes relevant to the object}

\item{name}{Name describing the experiment/plate/name/etc.}

\item{plates}{A list of \code{softermax.plate} objects}

\item{notes}{A list of \code{softermax.note} objects}

\item{wavelengths}{A list of \code{softermax.wavelength} objects}

\item{temperatures}{Temperature(s) at which plate was read (default: \code{NULL})}

\item{text_data}{A list of strings}

\item{wavelength}{An integer specifying a read wavelength}

\item{wells}{A list of \code{softermax.well} objects}

\item{times}{A vector of read times (numeric)}

\item{values}{A vector of read values (numeric)}

\item{x}{A data frame}

\item{wellsAsFactors}{A logical value indicating whether well names (e.g., "A6") should be treated as factors or not (default: \code{TRUE})}

\item{groupsAsFactors}{A logical value indicating whether well groups should be treated as factors or not (default: \code{TRUE})}

\item{typesAsFactors}{A logical value indicating whether well group types should be treated as factors or not (default: \code{TRUE})}
}
\value{
An object of the corresponding type
}
\description{
\code{softermax} creates a softermax object

\code{softermax.experiment} creates a softermax.experiment
object, which stores information about an experiment

\code{softermax.plate} creates a softermax.plate
object, which stores information about a plate

\code{softermax.note} creates a softermax.note
object, which stores information about a note

\code{softermax.wavelength} creates a softermax.wavelength
object, which stores information about a read at a particular wavelength

\code{softermax.well} creates a softermax.well
object, which stores information about a well in a microtiter plate

\code{softermax.template} creates a softermax.template
object, which stores layout information for a microtiter plate
}
\seealso{
\code{\link{is.softermax}}
}
