% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_reference_bed.R
\name{read_reference_bed}
\alias{read_reference_bed}
\title{Read a PLINK bed file for reference data}
\usage{
read_reference_bed(path, ...)
}
\arguments{
\item{path}{A path to the .bed file}

\item{...}{Further arguments used in \link[gaston:read.bed.matrix]{gaston::read.bed.matrix}}
}
\value{
A \link[gaston:bed.matrix-class]{gaston::bed.matrix} object with a Z-standardized genotype matrix
}
\description{
Create a \code{bed.matrix} object from a .bed file. The function expects
.fam and .bim files under the same directory. See \link[gaston:read.bed.matrix]{gaston::read.bed.matrix}
for more details.
}
\examples{
## Get a path to the example .bed file
bfile <- system.file("extdata", "example.bed", package = "snpsettest")

## Read a .bed file
x <- read_reference_bed(path = bfile)
}
