% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA.summary.table.R
\name{ANOVA.summary.table}
\alias{ANOVA.summary.table}
\title{Generate a Summary Table for ANOVA Results}
\usage{
ANOVA.summary.table(model, caption)
}
\arguments{
\item{model}{A model object for which ANOVA results are computed (e.g., output from `lm()` or `aov()`).}

\item{caption}{A character string to be used as the caption for the table.}
}
\value{
A LaTeX-formatted table generated by `kableExtra::kable()`.
}
\description{
This function creates a summary table for ANOVA results, including degrees of freedom,
sum of squares, mean squares, F-values, and p-values. The table is formatted for
LaTeX output using the `kableExtra` package.
}
\examples{
# Fit a linear model
model <- lm(mpg ~ wt + hp, data = mtcars)

# Generate the ANOVA summary table
ANOVA.summary.table(model, caption = "ANOVA Summary")
}
