% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_add_arrow.R
\name{sm_add_arrow}
\alias{sm_add_arrow}
\title{Adding an arrow annotation in the combined plot}
\usage{
sm_add_arrow(
  x,
  y,
  xend,
  yend,
  color = "black",
  linewidth = 0.5,
  type = "open",
  arrowlength = 1,
  ...
)
}
\arguments{
\item{x}{Starting location of the arrow along the x-axis of the combined figure. The middle origin is at 0.5.}

\item{y}{Starting location of the arrow along the y-axis of the combined figure. The middle origin is at 0.5.}

\item{xend}{Final location of the arrow along the x-axis of the combined figure. The middle origin is at 0.5.}

\item{yend}{Final location of the arrow along the y-axis of the combined figure. The middle origin is at 0.5.}

\item{color}{Color of the line. Default is set to black.}

\item{linewidth}{Thickness of the arrow Default is set to 0.5.}

\item{type}{Type of the arrow. Default is set to "open". Other choices include "both' and "closed".}

\item{arrowlength}{A unit specifying the length of the arrow head (from tip to base).}

\item{...}{Other parameters of the arrow line that will be transferred to the function annotate()}
}
\value{
Prints an arrow to the combined plot.
}
\description{
Adding an arrow annotation in the combined plot
}
\examples{
library(ggplot2)
library(smplot2)
ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
geom_point(shape = 21, fill = '#0f993d', color = 'white',
          size = 3) -> p1

ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
 geom_point(shape = 21, fill = '#0f993d', color = 'white', size = 3) +
 sm_hvgrid() -> p2

combined_fig <- sm_put_together(list(p1,p2), ncol=2,nrow=1)
combined_fig + sm_add_arrow(x = 0.4, y = 0.4, xend = 0.6, yend = 0.6)
}
