% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_add_rect.R
\name{sm_add_rect}
\alias{sm_add_rect}
\title{Adding a rectangle patch on the combined figure}
\usage{
sm_add_rect(
  combined_plot,
  xmin,
  ymin,
  xmax,
  ymax,
  fill = "gray80",
  color = "black",
  linewidth = 0.5,
  ...
)
}
\arguments{
\item{combined_plot}{Combined figure, an output from sm_put_together().}

\item{xmin}{Starting x value of the rectangle patch. Values from 0 to 1.}

\item{ymin}{Starting y value of the rectangle patch. Values from 0 to 1.}

\item{xmax}{Ending x value of the rectangle patch. Values from 0 to 1.}

\item{ymax}{Ending x value of the rectangle patch. Values from 0 to 1.}

\item{fill}{Fill color for the rectangle to be used}

\item{color}{Border line of the rectangle}

\item{linewidth}{Linewidth of border of the rectangle}

\item{...}{Other parameters to be used in annotate() from ggplot2.}
}
\value{
Prints a patch of rectangle onto a combined plot.
}
\description{
Areas captured by xmin, ymin, xmax and ymax will become a patch
once the function gets called.
}
\examples{
library(smplot2)
library(ggplot2)
ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
 geom_point(shape = 21, fill = '#0f993d', color = 'white',
            size = 3) -> p1

ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
 geom_point(shape = 21, fill = '#0f993d', color = 'white', size = 3) +
 sm_hvgrid() -> p2

combined_fig <- sm_put_together(list(p1,p2), ncol=2,nrow=1)
sm_add_rect(combined_fig, xmin = .5, ymin = .5, xmax =.6, ymax =.6)

}
