% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/central_limit_theorem.R
\name{clt}
\alias{clt}
\title{Central Limit Theorem (CLT)}
\usage{
clt(n = 20, distn, params = list(), panel_plot = TRUE, hscale = NA,
  vscale = hscale, n_add = 1, delta_n = 1, arrow = TRUE,
  leg_cex = 1.25, ...)
}
\arguments{
\item{n}{An integer scalar.  The size of the samples drawn from the
distribution chosen using \code{distn}.}

\item{distn}{A character scalar specifying the distribution from which
  observations are sampled.   Distributions \code{"beta"},
  \code{"binomial"}, \code{"chisq"}, \code{"chi-squared"},
  \code{"exponential"}, \code{"f"}, \code{"gamma"}, \code{"geometric"},
  \code{"gev"}, \code{"gp"}, \code{"hypergeometric"}, \code{"lognormal"},
  \code{"log-normal"}, \code{"negative binomial"}, \code{"normal"},
  \code{"poisson"}, \code{"t"}, \code{"uniform"} and \code{"weibull"} are
  recognised, case being ignored.

  If \code{distn} is not supplied then \code{distn = "exponential"}
  is used.

  The \code{"gev"} and \code{"gp"} cases use the
  \code{\link[revdbayes]{gev}} and \code{\link[revdbayes]{gp}}
  distributional functions in the
  \code{\link[revdbayes]{revdbayes}} package.

  The other cases use the distributional functions in the
  \code{\link[stats]{stats-package}}.
  If \code{distn = "gamma"} then the \code{(shape, rate)}
  parameterisation is used.  If \code{scale} is supplied via \code{params}
  then \code{rate} is inferred from this.
  If \code{distn = "negative binomial"} then the \code{(size, prob)}
  parameterisation is used.  If \code{mu} is supplied via \code{params}
  then \code{prob} is inferred from this (and \code{size}).
  If \code{distn = "beta"} then \code{ncp} is forced to be zero.}

\item{params}{A named list of additional arguments to be passed to the
  density function associated with distribution \code{distn}.
  The \code{(shape, rate)} parameterisation is used for the gamma
  distribution (see \code{\link[stats]{GammaDist}}) even if the value of
  the \code{scale} parameter is set using \code{params}.

  If a parameter value is not supplied then the default values in the
  relevant distributional function set using \code{distn} are used,
  except for
  \code{"beta"} (\code{shape1 = 2, shape2 = 2}),
  \code{"chisq"} (\code{df = 4}),
  \code{"f"} (\code{df1 = 4, df2 = 8}),
  \code{"gev"} (\code{shape = 0.2}).
  \code{"gamma"} (\code{shape = 2},
  \code{"gp"} (\code{shape = 0.1}),
  \code{"poisson"} (\code{lambda = 5}) and
  \code{"t"} (\code{df = 4}) and
  \code{"weibull"} (\code{shape = 2}).}

\item{panel_plot}{A logical parameter that determines whether the plot
is placed inside the panel (\code{TRUE}) or in the standard graphics
window (\code{FALSE}).  If the plot is to be placed inside the panel
then the tkrplot library is required.}

\item{hscale, vscale}{Numeric scalars.  Scaling parameters for the size
of the plot when \code{panel_plot = TRUE}. The default values are 1.4 on
Unix platforms and 2 on Windows platforms.}

\item{n_add}{An integer scalar.  The number of simulated datasets to add
to each new frame of the movie.}

\item{delta_n}{A numeric scalar.  The amount by which n is increased
(or decreased) after one click of the + (or -) button in the parameter
window.}

\item{arrow}{A logical scalar.  Should an arrow be included to show the
simulated sample mean from the top plot being placed into the
bottom plot?}

\item{leg_cex}{The argument \code{cex} to \code{\link[graphics]{legend}}.
Allows the size of the legend to be controlled manually.}

\item{...}{Additional arguments to the rpanel functions
\code{\link[rpanel]{rp.button}} and
\code{\link[rpanel]{rp.doublebutton}}, not including \code{panel},
\code{variable}, \code{title}, \code{step}, \code{action}, \code{initval},
\code{range}.}
}
\value{
Nothing is returned, only the animation is produced.
}
\description{
A movie to illustrate the ideas of the sampling distribution of a mean
and the central limit theorem.
}
\details{
Loosely speaking, a consequence of the
  \href{https://en.wikipedia.org/wiki/Central_limit_theorem}{Central Limit Theorem}
  is that the mean of a \strong{large number} of independent and
  identically distributed random variables, each with mean \eqn{\mu} and
  finite standard deviation \eqn{\sigma}, has \strong{approximately} a
  normal distribution, even if these original variables are not normally
  distributed.

  This movie considers examples where this limiting result holds and
  illustrates graphically the closeness of the limiting approximation
  provided by the relevant normal limit to the true finite-\eqn{n}
  distribution.  Of course, when \code{distn = "normal"} this result is
  exact.

  Samples of size \code{n} are repeatedly simulated from the distribution
  chosen using \code{distn}.  These samples are summarized using a plot
  that appears at the top of the movie screen.  For each sample the mean
  of these \code{n} values is calculated, stored and added to another plot,
  situated below the first plot.
  This plot is either a histogram or an empirical c.d.f., chosen using a
  radio button.
  A \code{\link[graphics]{rug}} is added to a histogram provided that it
  contains no more than 1000 points.

  The p.d.f. (for a continuous variable) or p.m.f. (for a discrete variable)
  of the original variables is added to the top plot.

  Once it starts, four aspects of this movie are controlled by the user.
  \itemize{
    \item{}{There are buttons to increase (+) or decrease (-) the sample
      size, that is, the number of values over which a mean is
      calculated.}
    \item{}{Each time the button labelled "simulate another \code{n_add}
      samples of size n" is clicked \code{n_add} new samples are simulated
      and their sample mean are added to the bottom histogram.}
    \item{}{There is a button to switch the bottom plot from displaying
      a histogram of the simulated means and the limiting normal p.d.f. to
      the empirical c.d.f. of the simulated data and the limiting normal
      c.d.f.}
    \item{}{There is a checkbox to add to the bottom plot the approximate
      (large \code{n}) normal p.d.f./c.d.f. (with mean \eqn{\mu} and
      standard deviation \eqn{\sigma / \sqrt{n}}), implied by the CLT.}
  }
}
\examples{
# Exponential data
clt()

# Uniform data
clt(distn = "uniform")

# Poisson data
clt(distn = "poisson")
}
\seealso{
\code{\link{movies}}: a user-friendly menu panel.

\code{\link{smovie}}: general information about smovie.

\code{\link{cltq}}: Central Limit Theorem for sample quantiles.
}
