% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iss.R
\name{iss}
\alias{iss}
\title{Intermittent State Space}
\usage{
iss(data, intermittent = c("none", "fixed", "interval", "probability", "sba",
  "logistic"), ic = c("AICc", "AIC", "BIC", "BICc"), h = 10,
  holdout = FALSE, model = NULL, persistence = NULL, initial = NULL,
  initialSeason = NULL, xreg = NULL)
}
\arguments{
\item{data}{Either numeric vector or time series vector.}

\item{intermittent}{Type of method used in probability estimation. Can be
\code{"none"} - none, \code{"fixed"} - constant probability,
\code{"croston"} - estimated using Croston, 1972 method and \code{"TSB"} -
Teunter et al., 2011 method., \code{"sba"} - Syntetos-Boylan Approximation
for Croston's method (bias correction) discussed in Syntetos and Boylan,
2005, \code{"logistic"} - probability based on logit model.}

\item{ic}{Information criteria to use in case of model selection.}

\item{h}{Forecast horizon.}

\item{holdout}{If \code{TRUE}, holdout sample of size \code{h} is taken from
the end of the data.}

\item{model}{Type of ETS model used for the estimation. Normally this should
be either \code{"ANN"} or \code{"MNN"}.}

\item{persistence}{Persistence vector. If \code{NULL}, then it is estimated.}

\item{initial}{Initial vector. If \code{NULL}, then it is estimated.}

\item{initialSeason}{Initial vector of seasonal components. If \code{NULL},
then it is estimated.}

\item{xreg}{Vector of matrix of exogenous variables, explaining some parts
of occurrence variable (probability).}
}
\value{
The object of class "iss" is returned. It contains following list of
values:

\itemize{
\item \code{model} - the type of the estimated ETS model;
\item \code{fitted} - fitted values of the constructed model;
\item \code{forecast} - forecast for \code{h} observations ahead;
\item \code{states} - values of states (currently level only);
\item \code{variance} - conditional variance of the forecast;
\item \code{logLik} - likelihood value for the model
\item \code{nParam} - number of parameters used in the model;
\item \code{residuals} - residuals of the model;
\item \code{actuals} - actual values of probabilities (zeros and ones).
\item \code{persistence} - the vector of smoothing parameters;
\item \code{initial} - initial values of the state vector;
\item \code{initialSeason} - the matrix of initials seasonal states;
}
}
\description{
Function calculates the probability for intermittent state space model. This
is needed in order to forecast intermittent demand using other functions.
}
\details{
The function estimates probability of demand occurrence, using one of the ETS
state space models.
}
\examples{

    y <- rpois(100,0.1)
    iss(y, intermittent="p")

    iss(y, intermittent="i", persistence=0.1)

}
\references{
\itemize{
\item Svetunkov Ivan and Boylan John E. (2017). Multiplicative
State-Space Models for Intermittent Time Series. Working Paper of
Department of Management Science, Lancaster University, 2017:4 , 1-43.
\item Teunter R., Syntetos A., Babai Z. (2011). Intermittent demand:
Linking forecasting to inventory obsolescence. European Journal of
Operational Research, 214, 606-615.
\item Croston, J. (1972) Forecasting and stock control for intermittent
demands. Operational Research Quarterly, 23(3), 289-303.
\item Syntetos, A., Boylan J. (2005) The accuracy of intermittent demand
estimates. International Journal of Forecasting, 21(2), 303-314.
}
}
\seealso{
\code{\link[forecast]{ets}, \link[forecast]{forecast},
\link[smooth]{es}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{demand}
\keyword{exponential}
\keyword{forecasting}
\keyword{intermittent}
\keyword{iss}
\keyword{model}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{smoothing}
\keyword{space}
\keyword{state}
\keyword{ts}
\keyword{univar}
