% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error-measures.R
\name{hm}
\alias{hm}
\alias{cbias}
\title{Half moment of a distribution and its derivatives.}
\usage{
hm(x, C = mean(x), digits = 5, ...)

cbias(x, C = mean(x), digits = 5, ...)
}
\arguments{
\item{x}{A variable based on which HM is estimated.}

\item{C}{Centering parameter.}

\item{digits}{Number of digits for rounding.}

\item{...}{Other parameters passed to mean function.}
}
\value{
A complex variable is returned for \code{hm} function and real value
is returned for \code{cbias}.
}
\description{
\code{hm} function estimates half moment from some predefined constant
\code{C}.  \code{cbias} function calculates bias based on \code{hm}.
}
\details{
\code{NA} values of \code{x} are excluded on the first step of calculation.
}
\examples{

x <- rnorm(100,0,1)
hm(x)
cbias(x)

}
\references{
TBA
}
\author{
Ivan Svetunkov
}
\keyword{distribution}
\keyword{half}
\keyword{moment}
\keyword{moments}
\keyword{of}
