% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sof.rastrigin.R
\name{makeRastriginFunction}
\alias{makeRastriginFunction}
\title{Rastrigin Function}
\usage{
makeRastriginFunction(dimensions)
}
\arguments{
\item{dimensions}{[\code{integer(1)}]\cr
Size of corresponding parameter space.}
}
\value{
[\code{smoof_single_objective_function}]
}
\description{
One of the most popular single-objective test functions consists of many
local optima and is thus highly multimodal with a global structure.
The implementation follows the formula
\deqn{f(\mathbf{x}) = 10n + \sum_{i=1}^{n} \left(\mathbf{x}_i^2 - 10 \cos(2\pi \mathbf{x}_i)\right).}
The box-constraints are given by \eqn{\mathbf{x}_i \in [-5.12, 5.12]} for
\eqn{i = 1, \ldots, n}.
}
\references{
L. A. Rastrigin. Extremal control systems. Theoretical Foundations
of Engineering Cybernetics Series. Nauka, Moscow, 1974.
}

