% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{closest}
\alias{closest}
\alias{closest,Grid-method}
\alias{closest,matrix-method}
\title{Find closest point(s) in a design or object.}
\usage{
closest(X, XNew, ...)
}
\arguments{
\item{X}{A matrix containing design points as rows or a
\code{"Grid"} object.}

\item{XNew}{A vector or matrix containing one or several 'new'
design points.}

\item{...}{Other arguments for methods.}
}
\value{
A list with elements
\item{index}{

Integer vector with length equal to the number of 'new' points. Contains
the index of the closest point in \code{X}.

}
\item{value}{

Matrix with one row for each 'new' design point containing the
closest point as found in \code{X}.

}
\item{dist}{

Numeric vector with length equal to the number of 'new' points. Contains
the minimal distances.

}
}
\description{
Find closest point(s) in a design matrix or object.
}
\details{
When \code{X} has class \code{"Grid"} weighting the factors
has no impact on the (or a) closest point since for each factor
there is normally one (and possibly two) level value(s) which
minimises the distance to the corresponding value in the given new
point (row) of \code{XNew}.
}
\examples{
## levels at 0, 0.2, 0.4, 0.6, 0.8, 1.0
g <- Grid(nlevels = c("x" = 6, "y" = 6, "z" = 6))
XNew <- c(0.51, 0.61, 0.23)
closest(X = g, XNew = XNew)
X <- as.matrix(g)
closest(X = X, XNew = XNew)
}

