% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_spm.R
\name{predict_spm}
\alias{predict_spm}
\alias{predict_spm.spm_fit}
\alias{predict_spm.sf}
\title{Prediction over the same or a different set of regions (or points).}
\usage{
predict_spm(x, ...)

\method{predict_spm}{spm_fit}(x, .aggregate = TRUE, ...)

\method{predict_spm}{sf}(x, spm_obj, n_pts, type, outer_poly = NULL, id_var, ...)
}
\arguments{
\item{x}{a \code{sf} object such that its geometris are either points or
polygons.}

\item{...}{additional parameters}

\item{.aggregate}{\code{logical}. Should the predictions be aggregated? In
case the input is only a "fit" object, the aggregation is made over the
polygons on which the original data was observed. In case the input
\code{x} is composed by \code{sf POLYGONS}, the aggregation is made over
this new partition of the study region.}

\item{spm_obj}{an object of either class \code{spm_fit} or \code{mspm_fit}}

\item{n_pts}{a \code{numeric} scalar standing for number of points to form a
grid over the whole region to make the predictions}

\item{type}{\code{character} type of grid to be generated. See
\code{st_sample} in the package \code{sf}.}

\item{outer_poly}{(object) \code{sf geometry} storing the "outer map" we
want to compute the predictions in.}

\item{id_var}{if \code{x} is a set of \code{POLYGONS} (areal data) instead
of a set of points, the \code{id_var} is the name (or index) of the
unique identifier associated to each polygon.}
}
\value{
a \code{list} of size 4 belonging to the class \code{spm_pred}. This
list contains the predicted values and the mean and covariance matrix
associated with the conditional distribution used to compute the
predictions.
}
\description{
Realizes predictions that can be useful when researchers are
interested in predict a variable observed in one political division of a
city (or state) on another division of the same region.
}
\examples{

data(liv_lsoa) ## loading the LSOA data
data(liv_msoa) ## loading the MSOA data

msoa_spm <- sf_to_spm(sf_obj = liv_msoa, n_pts = 500,
                      type = "regular", by_polygon = FALSE,
                      poly_ids = "msoa11cd",
                      var_ids = "leb_est")
## fitting model
theta_st_msoa <- c("phi" = 1) # initial value for the range parameter

fit_msoa <-
   fit_spm(x = msoa_spm,
           theta_st = theta_st_msoa,
           model = "matern",
           nu = .5,
           apply_exp  = TRUE,
           opt_method = "L-BFGS-B",
           control    = list(maxit = 500))

pred_lsoa <- predict_spm(x = liv_lsoa, spm_obj = fit_msoa, id_var = "lsoa11cd")

}
