% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dc.sim.R
\name{dc.sim}
\alias{dc.sim}
\title{Perform \code{dc.test} on simulated data}
\usage{
dc.sim(nsim = 1, nn, ty, ex, w, pop, max_pop, cl = NULL)
}
\arguments{
\item{nsim}{A positive integer indicating the number of
simulations to perform.}

\item{nn}{A list of distance-based nearest neighbors,
preferably from the \code{\link{nndist}} function.}

\item{ty}{The total number of cases in the study area.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{w}{A binary spatial adjacency matrix for the
regions.}

\item{pop}{The population size associated with each
region.}

\item{max_pop}{The population upperbound (in total
population) for a candidate zone.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
}
}
\value{
A vector with the maximum test statistic for each
  simulated data set.
}
\description{
\code{dc.sim} efficiently performs \code{\link{dc.test}}
on a simulated data set.  The function is meant to be
used internally by the \code{\link{dc.test}} function,
but is informative for better understanding the
implementation of the test.
}
\examples{
data(nydf)
data(nyw)
coords = with(nydf, cbind(longitude, latitude))
cases = floor(nydf$cases)
pop = nydf$pop
ty = sum(cases)
ex = ty/sum(pop) * pop
d = sp::spDists(coords, longlat = TRUE)
nn = nndist(d, ubd = 0.05)
max_pop = sum(pop) * 0.25
tsim = dc.sim(1, nn, ty, ex, nyw, pop = pop,
              max_pop = max_pop)
}
