% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rflex.test2.R
\name{rflex.test}
\alias{rflex.test}
\title{Restricted Flexibly-shaped Spatial Scan Test}
\usage{
rflex.test(
  coords,
  cases,
  pop,
  w,
  k = 50,
  ex = sum(cases)/sum(pop) * pop,
  type = "poisson",
  nsim = 499,
  alpha = 0.1,
  longlat = FALSE,
  alpha1 = 0.2,
  cl = NULL
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{w}{A binary spatial adjacency matrix for the
regions.}

\item{k}{An integer indicating the maximum number of
regions to inclue in a potential cluster.  Default is
10}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{type}{The type of scan statistic to compute. The
default is \code{"poisson"}. The other choice
is \code{"binomial"}.}

\item{nsim}{The number of simulations from which to
compute the p-value.}

\item{alpha}{The significance level to determine whether
a cluster is signficant.  Default is 0.10.}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used. If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}

\item{alpha1}{The middle p-value threshold.}

\item{cl}{
A cluster object created by \code{\link[parallel]{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
}
}
\value{
Returns a list of length two of class scan. The
  first element (clusters) is a list containing the
  significant, non-ovlappering clusters, and has the the
  following components: \item{coords}{The centroid of the
  significant clusters.} \item{r}{The radius of the
  window of the clusters.} \item{pop}{The total
  population in the cluster window.} \item{cases}{The
  observed number of cases in the cluster window.}
  \item{expected}{The expected number of cases in the
  cluster window.} \item{smr}{Standarized mortaility
  ratio (observed/expected) in the cluster window.}
  \item{rr}{Relative risk in the cluster window.}
  \item{loglikrat}{The loglikelihood ratio for the
  cluster window (i.e., the log of the test statistic).}
  \item{pvalue}{The pvalue of the test statistic
  associated with the cluster window.} The second element
  of the list is the centroid coordinates.  This is
  needed for plotting purposes.
}
\description{
\code{rflex.test} performs the restricted flexibly shaped
spatial scan test of Tango and Takahashi (2012).
}
\details{
The test is performed using the spatial scan test based
on the Poisson test statistic and a fixed number of
cases.  The first cluster is the most likely to be a
cluster.  If no significant clusters are found, then the
most likely cluster is returned (along with a warning).
}
\examples{
data(nydf)
data(nyw)
coords = with(nydf, cbind(longitude, latitude))
out = rflex.test(coords = coords, cases = floor(nydf$cases),
                 w = nyw, k = 10,
                 pop = nydf$pop, nsim = 49,
                 alpha = 0.05, longlat = TRUE)

data(nypoly)
library(sp)
plot(nypoly, col = color.clusters(out))
}
\references{
Tango, T. and Takahashi, K. (2012), A
  flexible spatial scan statistic with a restricted
  likelihood ratio for detecting disease clusters.
  Statist. Med., 31: 4207-4218. <doi:10.1002/sim.5478>
}
\seealso{
\code{\link{print.smerc_cluster}},
\code{\link{summary.smerc_cluster}},
\code{\link{plot.smerc_cluster}},
\code{\link{scan.stat}}, \code{\link{scan.test}}
}
\author{
Joshua French
}
