% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.metrics.plot}
\alias{smbinning.metrics.plot}
\title{Visualization of a Classification Matrix}
\usage{
smbinning.metrics.plot(df, cutoff = NA, plot = "cmactual")
}
\arguments{
\item{df}{Data frame generated with \code{smbinning.metrics}.}

\item{cutoff}{Value of the classifier that splits the data between positive (>=) and negative (<).}

\item{plot}{Plot to be drawn. Options are: 'cmactual' (default),'cmactualrates','cmmodel','cmmodelrates'.}
}
\description{
It generates four plots after running and saving the output report from \code{smbinning.metrics}.
}
\examples{
# Load library and its dataset
library(smbinning)
smbmetricsdf=smbinning.metrics(dataset=smbsimdf1, prediction="cbs1",
                               actualclass="fgood", returndf=1)

# Example 1: Plots based on optimal cutoff
smbinning.metrics.plot(df=smbmetricsdf,plot='cmactual')

# Example 2: Plots using user defined cutoff
smbinning.metrics.plot(df=smbmetricsdf,cutoff=600,plot='cmactual')
smbinning.metrics.plot(df=smbmetricsdf,cutoff=600,plot='cmactualrates')
smbinning.metrics.plot(df=smbmetricsdf,cutoff=600,plot='cmmodel')
smbinning.metrics.plot(df=smbmetricsdf,cutoff=600,plot='cmmodelrates')
}
