% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_mr.R
\name{fitStateMR}
\alias{fitStateMR}
\alias{fitViterbiMR}
\alias{fitPartialViterbiMR}
\title{Estimation of states at each time point with Moving-Resting Process}
\usage{
fitStateMR(data, theta, integrControl = integr.control())

fitViterbiMR(data, theta, integrControl = integr.control())

fitPartialViterbiMR(data, theta, startpoint, pathlength,
  integrControl = integr.control())
}
\arguments{
\item{data}{a \code{data.frame} whose first column is the observation
time, and other columns are location coordinates.}

\item{theta}{the parameters for Moving-Resting model, in the
order of rate of moving, rate of resting, volatility.}

\item{integrControl}{Integration control vector includes rel.tol,
abs.tol, and subdivisions.}

\item{startpoint}{Start time point of interested time interval.}

\item{pathlength}{the length of interested time interval.}
}
\value{
A \code{data.frame} contains estimated results, with elements:
\itemize{
 \item original data be estimated.
 \item conditional probability of moving, resting (\code{p.m},
\code{p.r}), which is \eqn{Pr(S(t = t_k) = s_k | X)} for
\code{fitStateMR}; \eqn{log-Pr(s_0, ..., s_k | X_k)} for
\code{fitViterbiMR}, where \eqn{X_k} is \eqn{(X_0, ..., X_k)};
and \eqn{log-Pr(s_k, ..., s_{k+q-1}|X)} for \code{fitPartialViterbiMR}.
 \item estimated states with 1-moving, 0-resting.
}
}
\description{
Estimate the state at each time point under the Moving-Resting
process with Embedded Brownian Motion with animal movement data at
discretely time points. See the difference between \code{fitStateMR}
and \code{fitViterbiMR} in detail part. Using \code{fitPartialViterbiMR}
to estimate the state within a small piece of time interval.
}
\details{
\code{fitStateMR} estimates the most likely state by maximizing
the probability of \eqn{Pr(S(t = t_k) = s_k | X)}, where X is the whole
data and \eqn{s_k} is the possible sates at \eqn{t_k} (moving, resting).

\code{fitViterbiMR} estimates the most likely state path by maximizing
\eqn{Pr(S(t = t_0) = s_0, S(t = t_1) = s_1, ..., S(t = t_n) = s_n | X)}, where
X is the whole data and \eqn{s_0, s_1, ..., s_n} is the possible
state path.

\code{fitPartialViterbiMR} estimates the most likely state path of
a small peice of time interval, by maximizing the probability of
\eqn{Pr(S(t = t_k) = s_k, ..., S(t = t_{k+q-1}) = s_{k+q-1} | X)},
where \eqn{k} is the start time point and \eqn{q} is the length of interested
time interval.
}
\examples{
set.seed(06269)
tgrid <- seq(0, 400, by = 8)
dat <- rMR(tgrid, 4, 3.8, 5, 'm')
fitStateMR(dat, c(4, 3.8, 5))
fitViterbiMR(dat, c(4, 3.8, 5))
fitPartialViterbiMR(dat, c(4, 3.8, 5), 20, 10)

}
\seealso{
\code{\link{rMR}} for simulation.
\code{\link{fitMR}} for estimation of parameters.
}
\author{
Chaoran Hu
}
