% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets_sizing.R
\name{sets_sizing}
\alias{sets_sizing}
\title{Sets sizing}
\usage{
sets_sizing(
  captions = NULL,
  columns = NULL,
  data = NULL,
  icons = NULL,
  legend = NULL,
  resume = NULL,
  tiles = NULL
)
}
\arguments{
\item{captions}{Positive numeric value for caption text size.}

\item{columns}{Positive numeric value for column name text size.}

\item{data}{Positive numeric value for printed data text size.}

\item{icons}{Positive numeric value for legend icon size.}

\item{legend}{Positive numeric value for legend text size.}

\item{resume}{Positive numeric value for resume marker size.}

\item{tiles}{Positive numeric value for Smallset tile size.}
}
\value{
Returns a list with seven elements (the sizing parameters).
}
\description{
Sets sizing parameters for the Smallset Timeline.
}
\details{
Passed to \code{sizing} in \link{Smallset_Timeline}.
}
\examples{
# increase size of caption text
Smallset_Timeline(
   data = s_data,
   code = system.file("s_data_preprocess.R", package = "smallsets"),
   sizing = sets_sizing(captions = 3.5)
)

}
