\name{stat.Newton}
\alias{stat.Newton}

\title{Apply Newtons single slide method}

\description{
Applies Newtons single slide method. 
}


\usage{
stat.Newton(RG,layout,norm="p", image.id=1,pout=TRUE)

}

\arguments{
  \item{RG}{
    a list with 4 elements, each represents a matrix with p rows for p
    genes and n columns for n slides. \cr
    The first element "R" contains the raw red intensities from slide
    i=1,...,n .\cr
    Similarly, the second element "G" contains the raw green
    intensities. \cr
    The third element "Rb"  contains the background red intensities and \cr
    the fourth element "Gb" contains the  background green intensities.\cr
    This list structure can be generated by the interactive function
    \code{\link{init.data}}. }
  
  \item{layout}{a list specifying the dimensions of the spot matrix and the grid
    matrix.  This can be generated by calling \code{\link{init.grid}}.}

  \item{norm}{Character string, one of "n", "m", "l", "p" or "s".  This
    argument specifies the type of normalization method to be performed:
    "n" no normalization between the 2 channels; "m"
    \code{\link{median}} normalization, which sets the median of log
    intensity ratios to zero; "l" global \code{\link{lowess}}
    normalization; "p" print-tip group lowess normalization and "s"
    scaled print-tip group lowess normalization. The default method is
    set to print-tip normalization.}

 \item{image.id}{Specifies image to which Chen's method will be applied.}
  
  \item{pout}{if TRUE, an M vs. A plot will be produced with limits due
    to Newton, Specifically limits at the 1:1, 1:10 and 1:100 log odds ratio. If FALSE, return a list with pertinant information}
    
}


\value{
  List containing the following components:

  \item{theta}{parameters estimated by EM algorithm}
  \item{lod}{Log odds ratio of being differentially expressed for each gene}

}

\references{
  Newton, M.N., C.M. Kendziorski, C.S. Richmond, F.R. Blattner, and
  K.W. Tsui . On differential variability of expression ratios:
  Improving statistical inference about gene expression changes from
  microarray data. Technical Report 139, Department of Biostatistics and
  Medical Informatics, UW Madison, 1999. \url{http://www.stat.wisc.edu/~newton/papers/abstracts/btr139a.html}
}

\author{
  Ben Bolstad, \email{bolstad@stat.berkeley.edu}
}

\seealso{\code{\link{stat.Chen}},\code{\link{stat.ChurSap}}}

\examples{
data(MouseArray)
##mouse.setup <- init.grid() 
##mouse.data <- init.data() ## see \emph{init.data}
stat.Newton(mouse.data,mouse.setup,image.id=3)
}

\keyword{models}

