% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bash.R
\name{slurm_available}
\alias{slurm_available}
\alias{sbatch}
\alias{submit}
\alias{sbatch.slurm_job}
\alias{sbatch.character}
\alias{squeue}
\alias{squeue.default}
\alias{squeue.slurm_job}
\alias{scancel}
\alias{scancel.default}
\alias{scancel.slurm_job}
\alias{sacct}
\alias{sacct.default}
\alias{sacct.slurm_job}
\alias{slurm.conf}
\alias{SchedulerParameters}
\title{R wrappers for \emph{Slurm} commands}
\usage{
slurm_available()

sbatch(x, wait = FALSE, submit = TRUE, ...)

\method{sbatch}{slurm_job}(x, wait = FALSE, submit = TRUE, ...)

\method{sbatch}{character}(x, wait = FALSE, submit = TRUE, ...)

squeue(x = NULL, ...)

\method{squeue}{default}(x = NULL, ...)

\method{squeue}{slurm_job}(x, ...)

scancel(x = NULL, ...)

\method{scancel}{default}(x = NULL, ...)

\method{scancel}{slurm_job}(x = NULL, ...)

sacct(x, ...)

\method{sacct}{default}(x = NULL, brief = TRUE, parsable = TRUE, allocations = TRUE, ...)

\method{sacct}{slurm_job}(x, ...)

slurm.conf()

SchedulerParameters()
}
\arguments{
\item{x}{Either an object of class \code{slurm_job}, or, in some cases, an
integer as a Slurm jobid. Note that some functions allow passing no arguments.}

\item{wait}{Logical scalar. When \code{TRUE} the function will pass the \code{--wait}
flag to \code{Slurm} and set \code{wait = TRUE} in the \link{system2} call.}

\item{submit}{Logical, when \code{TRUE} calls \link{sbatch} to submit the job to slurm.}

\item{...}{Further flags passed to the command line function.}

\item{brief, parsable, allocations}{Logical. When \code{TRUE}, these are passed as flags directly
to the command line function \code{sacct}.}
}
\value{
In the case of \code{sbatch}, depends on what \code{x} is:
\itemize{
\item If \code{x} is of class \link{slurm_job}, then it returns the same object including
the Slurm job ID (if the job was submitted to the queue).
\item If \code{x} is a file path (e.g. a bash script), an integer with the jobid number
(again, if the job was submitted to Slurm).
}

The functions \code{squeue} and \code{sacct} return a data frame with the information
returned by the command line utilities. The function \code{scancel} returns NULL.

\code{slurm_available()} returns a logical scalar equal to \code{TRUE} if Slurm is
available.

\code{slurm.conf()} and \code{SchedulerParameters()} return information about the
Slurm cluster, if available.
}
\description{
The functions \code{sbatch}, \code{scancel}, \code{squeue}, \code{sacct}, and \code{slurm.conf} are
wrappers of calls to Slurm functions via \link{system2}.
}
\details{
The function \code{slurm_available} checks whether Slurm is available in
the system or not. It is usually called before calling any bash wrapper.
If available, the function will return \code{TRUE}, otherwise \code{FALSE}.

In the case of \code{sbatch}, function takes an object of class \code{slurm_job} and
submits it to the queue. In debug mode the job will be submitted via \code{sh}
instead.

The method for character scalars is used to submit jobs using a slurm
script.

The wrapper of squeue includes the flag \verb{-o\%all} which returns all
available fields separated by a vertical bar. This cannot be changed since it
is the easiest way of processing the information in R.

The function \code{slurm.conf} is a wrapper of the function \code{scontrol} that
returns configuration info about Slurm, in particular, the underlying command
that is called is \verb{scontrol show conf}. This returns a named character vector
with configuration info about the cluster. The name of this function matches
the name of the file that holds this information.

The function \code{SchedulerParameters} is just a wrapper of \link{slurm.conf}.
It processes the field "SchedulerParameters" included in the configuration
file and has information relevant for the scheduler.
}
\examples{
# Are we under a Slurm Cluster?
slurm_available()

\dontrun{
# Submitting a simple job
job <- Slurm_EvalQ(slurmR::WhoAmI(), njobs = 4L, plan = "submit")

# Checking the status of the job (we can simply print)
job
status(job) # or use the state function
sacct(job) # or get more info with the sactt wrapper.

# Suppose one of the jobs is taking too long to complete (say #4)
# we can stop it and resubmit the job as follows:
scancel(job)

# Resubmitting only 4
sbatch(job, array = 4) # A new jobid will be assigned

}

\dontrun{
# What is the maximum number of jobs (array size) that the system
# allows?
sconfig <- slurm.conf() # We first retrieve the info.
sconfig["MaxArraySize"]
}

}
