% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftype.R
\name{ftype}
\alias{ftype}
\title{Determine function type.}
\usage{
ftype(f)
}
\arguments{
\item{f}{unquoted function name}
}
\value{
a character of vector of length 1 or 2.
}
\description{
This function figures out whether the input function is a
regular/primitive/internal function, a internal/S3/S4 generic, or a
S3/S4/RC method. This is function is slightly simplified as it's possible
for a method from one class to be a generic for another class, but that
seems like such a bad idea that hopefully no one has done it.
}
\examples{
ftype(`\%in\%`)
ftype(sum)
ftype(t.data.frame)
ftype(t.test) # Tricky!
ftype(writeLines)
ftype(unlist)
}
\concept{object inspection}
